-- Create schema for multiple runs
DROP SCHEMA IF EXISTS DDLHomework;
CREATE SCHEMA DDLHomework;
USE DDLHomework;

-- Create Office Table
CREATE TABLE Office (
Office_Number INT,
City VARCHAR(20),
State VARCHAR (2),
Zip_code VARCHAR(10),
CONSTRAINT PRIMARY KEY (Office_Number)
);

-- Insert data into Office Table
INSERT INTO Office VALUES (1, 'Atlanta', 'GA', '30068');
INSERT INTO Office VALUES (2, 'New Orleans', 'LA', '70043');
INSERT INTO Office VALUES (3, 'Memphis', 'TN', '38002-7080');

-- Create Property Table
CREATE TABLE Property (
Property_ID VARCHAR(10),
Street_Address VARCHAR(45),
Prop_City VARCHAR(20),
Prop_State VARCHAR(2),
Prop_Zip VARCHAR(10),
Office_Number INT,
CONSTRAINT PRIMARY KEY (Property_ID),
CONSTRAINT FOREIGN KEY (Office_Number) REFERENCES Office(Office_Number)
);

-- Insert Data into Property Table
INSERT INTO Property VALUES ('P1', '120 Beale Street', 'Memphis', 'TN', '70082', 3);
INSERT INTO Property VALUES ('P2', '8000 Ponce De Leon Avenue', 'Atlanta', 'GA', '30306', 1);
INSERT INTO Property VALUES ('P3', '182 Royal Street', 'New Orleans', 'LA', '70130', 2);

-- Create Prop_Owner Table
CREATE TABLE Prop_Owner (
Owner_ID INT,
Owner_FirstName VARCHAR(45),
Owner_LastName VARCHAR(45),
Owner_Phone VARCHAR(10),
CONSTRAINT PRIMARY KEY (Owner_ID)
);

-- Insert data into Prop_Owner Table
INSERT INTO Prop_Owner VALUES (10, 'Michael', 'Matthew', '6787337008');
INSERT INTO Prop_Owner VALUES (20, 'Josie', 'Molina', '4043345678');
INSERT INTO Prop_Owner VALUES (30, 'Wei', 'Long', '5546771200');

-- Create Property_Has_Owner Table
CREATE TABLE Property_has_Owner (
Property_ID VARCHAR(10),
Owner_ID INT,
Percent_Owned DECIMAL(5,2),
CONSTRAINT PRIMARY KEY (Property_ID, Owner_ID),
CONSTRAINT FOREIGN KEY (Property_ID) REFERENCES Property(Property_ID),
CONSTRAINT FOREIGN KEY (Owner_ID) REFERENCES Prop_Owner(Owner_ID)
);

-- Insert Data into Property_Has_Owner Table
INSERT INTO Property_Has_Owner VALUES ('P1', 10, 35.00);
INSERT INTO Property_Has_Owner VALUES ('P1', 20, 65.00);
INSERT INTO Property_Has_Owner VALUES ('P2', 20, 100.00);
INSERT INTO Property_Has_Owner VALUES ('P3', 30, 75.00);










