
create schema QAC;
use QAC;

CREATE  TABLE CUSTOMER(
	CustomerID			        Int				        NOT NULL AUTO_INCREMENT,
	LastName			          Char(25)		      NOT NULL,
	FirstName			          Char(25)		      NOT NULL,
	Address				          Char(35)		      NULL,
	City				            Char(35)		      NULL,
	State				            Char(2)			      NULL,
	ZIP					            Char(10)		      NULL,
	Phone				            Char(12)		      NOT NULL,
	Email				            VarChar(100)	    NULL,
	CONSTRAINT 			        CUSTOMER_PK 	    PRIMARY KEY(CustomerID)
	);

CREATE  TABLE EMPLOYEE(
	EmployeeID			        Int 			        NOT NULL AUTO_INCREMENT,
	LastName			          Char(25) 		      NOT NULL,
	FirstName			          Char(25) 		      NOT NULL,
	Phone				            Char(12)		      NULL,
	Email 				          VarChar(100)	    NOT NULL UNIQUE,
	CONSTRAINT 			        EMPLOYEE_PK 	    PRIMARY KEY(EmployeeID)
	);


CREATE  TABLE SALE(
  SaleID				          Int				       NOT NULL AUTO_INCREMENT,
	CustomerID			        Int	 			       NOT NULL,
	EmployeeID			        Int				       NOT NULL,
	SaleDate			          DateTime		     NOT NULL,
	SubTotal			          Numeric(15,2)	   NULL,
	Tax					            Numeric(15,2)	   NULL,
	Total				            Numeric(15,2)	   NULL,
  CONSTRAINT 			    SALE_PK 		         PRIMARY KEY (SaleID),
	CONSTRAINT 			    SALE_CUSTOMER_FK     FOREIGN KEY (CustomerID)
								          REFERENCES Customer(CustomerID)
										          ON UPDATE NO ACTION
										          ON DELETE NO ACTION,
	CONSTRAINT 	        SALE_EMPLOYEE_FK     FOREIGN KEY(EmployeeID)
								          REFERENCES Employee(EmployeeID)
										          ON UPDATE NO ACTION
										          ON DELETE NO ACTION
  );

