/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.curve;

import hipparcos.curve.HIPEPFactory;
import hipparcos.curve.HIP_EP;
import hipparcos.curve.PlotCurve;
import hipparcos.tools.Browser;
import hipparcos.tools.MainFrame;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LightCurve
extends Applet
implements ActionListener {
    private PlotCurve theCurve;
    private HIP_EP ep;
    private Label info1;
    private Label info2;
    private TextField periodField;
    private String dataDir;
    private double step = 1.0;
    private TextField hipfield;
    private int pwidth = 10;
    private String fname = null;

    public static void main(String[] argv) {
        LightCurve ap = null;
        ap = argv.length > 0 ? new LightCurve(argv[0]) : new LightCurve();
        Browser.setMainFrame();
        new MainFrame(ap, null, 800, 450);
    }

    public LightCurve() {
    }

    public LightCurve(String fname) {
        this.fname = fname;
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(800, 400);
    }

    @Override
    public void init() {
        Browser.setAppletContext(this.getAppletContext());
        this.setLayout(new BorderLayout());
        Panel info = new Panel();
        info.setLayout(new GridLayout(2, 1));
        this.info1 = new Label("No Data ........");
        this.info2 = new Label("........");
        info.add("1", this.info1);
        info.add("2", this.info2);
        this.add("North", info);
        this.theCurve = new PlotCurve();
        this.add("Center", this.theCurve);
        Panel p = new Panel();
        Label hf = new Label("HIP");
        this.hipfield = new TextField(7);
        this.hipfield.addActionListener(this);
        System.out.println("Setting up");
        if (this.fname != null) {
            try {
                this.ep = HIPEPFactory.get(this.fname);
            }
            catch (Exception e) {
                System.err.println("Could not load " + this.fname);
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            p.add("West", hf);
            p.add("West", this.hipfield);
            Button hipUp = new Button("prev");
            p.add("West", hipUp);
            Button hipDown = new Button("next");
            p.add("West", hipDown);
            try {
                this.ep = HIPEPFactory.get(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Label t2 = new Label("Trial Period (days):");
        p.add("West", t2);
        this.periodField = new TextField(this.pwidth);
        p.add("East", this.periodField);
        Button upButton = new Button("inc");
        p.add("East", upButton);
        Button downButton = new Button("dec");
        p.add("East", downButton);
        Label t3 = new Label("Step:");
        p.add("East", t3);
        Choice choice = new Choice();
        choice.addItem("10.0");
        choice.addItem(" 1.0");
        choice.addItem(" 0.1");
        choice.addItem(" 0.01");
        choice.addItem(" 0.001");
        choice.addItem(" 0.0001");
        choice.addItem(" 0.00001");
        choice.addItem(" 0.000001");
        p.add("East", choice);
        choice.select(" 1.0");
        this.add("South", p);
        this.newHipep();
    }

    private void newHipep() {
        this.info1.setText(this.ep.getInfoText1());
        this.info2.setText(this.ep.getInfoText2());
        this.theCurve.setEp(this.ep);
        this.periodField.setText(new Double(this.theCurve.getPeriod()).toString());
        this.hipfield.setText(" " + this.ep.getHipNumber());
    }

    @Override
    public boolean action(Event evt, Object obj) {
        switch (evt.id) {
            case 1001: {
                String tmpS;
                if (evt.target instanceof TextField) {
                    if (evt.target == this.hipfield) {
                        Integer hipid = Integer.valueOf(((String)evt.arg).trim());
                        try {
                            this.ep = HIPEPFactory.get(hipid);
                        }
                        catch (Exception e) {
                            this.info1.setText("Bad Hipnumber " + hipid.toString());
                        }
                        this.newHipep();
                    } else {
                        Double period = Double.valueOf((String)evt.arg);
                        this.theCurve.setPeriod(period);
                    }
                }
                if (evt.target instanceof Choice) {
                    Double val = Double.valueOf((String)evt.arg);
                    this.step = val;
                }
                if (!(evt.target instanceof Button)) break;
                Button theButton = (Button)evt.target;
                String label = theButton.getLabel();
                double presper = this.theCurve.getPeriod();
                Double period = new Double(0.0);
                int hipid = this.ep.getHipNumber();
                boolean found = false;
                if (label == "Quit") {
                    System.exit(0);
                }
                if (label == "next") {
                    if (hipid >= 120415) {
                        hipid = 0;
                    }
                    if (hipid == 120404) {
                        hipid = 120414;
                    }
                    if (hipid == 120313) {
                        hipid = 120400;
                    }
                    if (hipid == 120082) {
                        hipid = 120120;
                    }
                    if (hipid == 120047) {
                        hipid = 120070;
                    }
                    if (hipid == 120027) {
                        hipid = 120045;
                    }
                    if (hipid == 120006) {
                        hipid = 120026;
                    }
                    if (hipid == 118322) {
                        hipid = 120000;
                    }
                    while (!found) {
                        ++hipid;
                        try {
                            this.ep = HIPEPFactory.get(hipid);
                            if (this.ep == null) continue;
                            found = this.ep.getHipNumber() > 0;
                        }
                        catch (Exception exception) {}
                    }
                    this.newHipep();
                }
                if (label == "prev") {
                    if (hipid <= 1) {
                        hipid = 120416;
                    }
                    if (hipid == 120000) {
                        hipid = 118321;
                    }
                    if (hipid == 120026) {
                        hipid = 120007;
                    }
                    if (hipid == 120046) {
                        hipid = 120027;
                    }
                    if (hipid == 120071) {
                        hipid = 120047;
                    }
                    if (hipid == 120121) {
                        hipid = 120083;
                    }
                    if (hipid == 120401) {
                        hipid = 120314;
                    }
                    if (hipid == 120415) {
                        hipid = 120405;
                    }
                    while (!found) {
                        --hipid;
                        try {
                            if (this.ep != null) {
                                this.ep = HIPEPFactory.get(hipid);
                            }
                            if (this.ep == null) continue;
                            found = this.ep.getHipNumber() > 0;
                        }
                        catch (Exception exception) {}
                    }
                    this.newHipep();
                }
                if (label == "inc") {
                    period = new Double(presper + this.step + 1.0E-7);
                    tmpS = this.truncate(period, 6);
                    this.periodField.setText(tmpS);
                    this.theCurve.setPeriod(new Double(tmpS));
                }
                if (label != "dec") break;
                period = new Double(presper - this.step + 1.0E-7);
                tmpS = this.truncate(period, 6);
                this.periodField.setText(tmpS);
                this.theCurve.setPeriod(new Double(tmpS));
            }
        }
        return true;
    }

    @Override
    public String getAppletInfo() {
        return "Light Curve by wil";
    }

    public String truncate(Double period, int ad) {
        int end;
        String tmpS = period.toString();
        int dot = tmpS.indexOf(46) + 1;
        if (dot + ad < (end = tmpS.length())) {
            end = dot + ad;
        }
        return tmpS.substring(0, end);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof TextField) {
            if (evt.getSource() == this.hipfield) {
                Integer hipid = Integer.valueOf(this.hipfield.getText().trim());
                try {
                    this.ep = HIPEPFactory.get(hipid);
                }
                catch (Exception e) {
                    this.info1.setText("Bad Hipnumber " + hipid.toString());
                }
                this.newHipep();
            } else {
                Double period = Double.valueOf(this.periodField.getText());
                this.theCurve.setPeriod(period);
            }
        }
    }
}

