/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.curve;

import hipparcos.curve.EPpoint;
import hipparcos.curve.HIP_EP;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class PlotCurve
extends Canvas {
    private HIP_EP ep = null;
    private double period;
    private int rectWidth;
    private int rectHeight;
    private int border;
    private int bottomRule;
    private int leftRule;
    private int rightRule;

    private void init() {
        this.rectWidth = 3;
        this.rectHeight = 3;
        this.border = 25;
        this.bottomRule = 20;
        this.rightRule = 20;
        this.leftRule = 50;
        this.period = 50.0;
        this.setBackground(Color.white);
    }

    public PlotCurve() {
        this.init();
    }

    @Override
    public void paint(Graphics g) {
        if (this.ep != null && this.ep.getHipNumber() != 0) {
            this.plotGraph(g);
        } else {
            g.setColor(Color.red);
            g.drawString("Data Not Loaded", 20, this.size().height / 2);
        }
    }

    public void plotGraph(Graphics g) {
        Dimension d = this.size();
        int phaseWidth = d.width - this.leftRule - this.rightRule;
        phaseWidth = phaseWidth * 2 / 3;
        double scaleX = this.period / (double)phaseWidth;
        double scaleY = this.ep.getHpRange() / (double)(d.height - this.border * 2 - this.bottomRule);
        this.drawRulers(g, scaleY, this.ep.getMinHp(), this.ep.getMaxHp(), this.ep.getMedianMagnitude());
        Vector Epoints = this.ep.getEPpoints();
        EPpoint p = (EPpoint)Epoints.elementAt(0);
        Enumeration e = Epoints.elements();
        while (e.hasMoreElements()) {
            p = (EPpoint)e.nextElement();
            if (p.qualityFlag != 0 && p.qualityFlag != 1) continue;
            double adjustedBJD = (p.BJD - this.ep.getRefferenceEpoch()) % this.period;
            if (adjustedBJD < 0.0) {
                adjustedBJD += this.period;
            }
            int x = this.leftRule + (int)(adjustedBJD / scaleX);
            int y = this.border + (int)((p.Hp - this.ep.getMinHp()) / scaleY);
            int err = (int)(p.standardError / scaleY);
            this.plotPoint(g, x, y, err, p.qualityFlag);
            if (x + phaseWidth < d.width - this.rightRule) {
                this.plotPoint(g, x + phaseWidth, y, err, p.qualityFlag);
            }
            if (y > d.height - this.border) {
                System.err.println("Height " + d.height + " y " + y + " p.Hp " + p.Hp);
            }
            if (x >= this.leftRule && x <= d.width - this.rightRule) continue;
            System.err.println("Left " + this.leftRule + " x " + x + " p.BJD " + p.BJD);
        }
    }

    private float getYstep(float range) {
        Float ret = new Float(0.0f);
        if (range > 1.0f) {
            ret = new Float(0.5f);
        }
        if (range < 1.0f && (double)range > 0.5) {
            ret = new Float(0.1f);
        }
        if ((double)range < 0.5 && (double)range > 0.3) {
            ret = new Float(0.05f);
        }
        if ((double)range < 0.3) {
            ret = new Float(0.01f);
        }
        return ret.floatValue();
    }

    private void drawRulers(Graphics g, double scaleY, double minY, double maxY, double median) {
        int cShift = 9;
        float range = (float)(maxY - minY);
        float ystep = this.getYstep(range);
        Float stF = new Float(ystep);
        g.setColor(Color.blue);
        g.drawString("Scale: ", 1, 12);
        g.drawString(stF.toString(), 40, 12);
        float highY = (float)(maxY - maxY % (double)ystep);
        float lowY = (float)(minY + (double)ystep - minY % (double)ystep);
        int posHighY = this.border - cShift / 2 + (int)((maxY - minY) / scaleY);
        int posLowY = this.border - cShift / 2;
        Dimension d = this.size();
        int medianLine = this.border + (int)((median - minY) / scaleY);
        g.setColor(Color.black);
        g.drawLine(this.leftRule - 1, this.border, this.leftRule - 1, d.height - this.bottomRule);
        g.drawLine(this.leftRule - 1, d.height - this.bottomRule, d.width - this.rightRule, d.height - this.bottomRule);
        g.setColor(Color.red);
        g.drawLine(this.leftRule - 1, medianLine, d.width - this.rightRule, medianLine);
        g.setColor(Color.blue);
        g.drawString("" + minY, 1, posLowY + cShift);
        g.drawString("" + maxY, 1, posHighY + cShift);
        float endval = highY + ystep;
        for (float tick = lowY; tick <= highY; tick += ystep) {
            int posTick = this.border + (int)(((double)tick - minY) / scaleY);
            g.drawLine(this.leftRule - 5, posTick, this.leftRule, posTick);
        }
        g.drawString("Phase", d.width / 2 - 10, d.height - 3);
        int quarterPhase = (d.width - this.leftRule - this.rightRule) / 6;
        g.drawString("0.0", this.leftRule - cShift, d.height - 3);
        g.drawString("0.5", this.leftRule + 2 * quarterPhase - cShift, d.height - 3);
        g.drawString("1.0", this.leftRule + 4 * quarterPhase - cShift, d.height - 3);
        g.drawString("1.5", d.width - cShift - this.rightRule, d.height - 3);
        for (int i = 0; i < 7; ++i) {
            int x = this.leftRule + i * quarterPhase;
            g.drawLine(x, d.height - this.bottomRule, x, d.height - this.bottomRule + 5);
        }
    }

    private void plotPoint(Graphics g, int x, int y, int err, int quality) {
        if (quality == 0) {
            this.plotSquare(g, x, y, err);
        } else {
            this.plotTriangle(g, x, y, err);
        }
    }

    private void plotSquare(Graphics g, int x, int y, int err) {
        g.setColor(Color.cyan);
        g.drawLine(x, y - err, x, y + err);
        g.setColor(Color.blue);
        g.drawRect(x - (this.rectWidth - 1) / 2, y - (this.rectHeight - 1) / 2, this.rectWidth, this.rectHeight);
        g.fillRect(x - (this.rectWidth - 1) / 2, y - (this.rectHeight - 1) / 2, this.rectWidth, this.rectHeight);
    }

    private void plotTriangle(Graphics g, int x, int y, int err) {
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        xpoints[0] = x;
        ypoints[0] = y - this.rectHeight;
        xpoints[1] = x - this.rectWidth + 1;
        ypoints[1] = y + (this.rectHeight - 1) / 2;
        xpoints[2] = x + this.rectWidth - 1;
        ypoints[2] = y + (this.rectHeight - 1) / 2;
        xpoints[3] = x;
        ypoints[3] = y - this.rectHeight;
        g.setColor(Color.cyan);
        g.drawLine(x, y - err, x, y + err);
        g.setColor(Color.black);
        g.drawPolygon(xpoints, ypoints, 4);
    }

    public void setEp(HIP_EP ep) {
        this.ep = ep;
        this.period = ep.getSolutionPeriod() != 0.0 ? ep.getSolutionPeriod() : 50.0;
        this.repaint();
    }

    public void setPeriod(double period) {
        if (this.period != period) {
            this.period = period;
            this.repaint();
        }
    }

    public HIP_EP getEp() {
        return this.ep;
    }

    public double getPeriod() {
        return this.period;
    }
}

