/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import hipparcos.hipi.PlotFit;
import hipparcos.plot.DPoint;
import java.awt.Color;
import java.awt.Graphics;

public class Bary
implements Runnable {
    private Thread glow = null;
    private Graphics g;
    PlotFit plot;
    private boolean suspended = true;
    private DPoint[] bary = null;
    private DPoint[] norm = null;
    private int step = 0;
    private int delay = 600;
    private int xpos;
    private int ypos;
    private int oldxpos;
    private int oldypos;
    private int nxpos;
    private int nypos;
    private int oldnxpos;
    private int oldnypos;

    public Bary(Graphics g, PlotFit plot) {
        this.plot = plot;
        this.g = g;
        this.step = 0;
        this.glow = new Thread(this);
        this.glow.start();
        this.setOldPos(-1, -1, -1, -1);
        this.suspended = true;
    }

    public Bary(Graphics g, PlotFit plot, DPoint[] bary, DPoint[] norm) {
        this.plot = plot;
        this.g = g;
        this.bary = bary;
        this.norm = norm;
        this.step = 0;
        this.glow = new Thread(this);
        this.suspended = false;
        this.glow.start();
    }

    public void setBary(DPoint[] bary, DPoint[] norm) {
        this.step = 0;
        this.setOldPos(-1, -1, -1, -1);
        this.bary = bary;
        this.norm = norm;
    }

    public void start() {
        if (this.glow != null) {
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception e) {
                System.err.println("start in Bary- thred problem");
            }
            this.suspended = false;
        }
    }

    public void start(Graphics g) {
        this.g = g;
        this.start();
    }

    public void stop() {
        if (this.glow != null) {
            this.suspended = true;
            this.setOldPos(-1, -1, -1, -1);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.suspended) continue;
            this.redraw();
        }
    }

    private void redraw() {
        if (this.bary != null) {
            Color tmp = this.g.getColor();
            if (this.oldxpos >= 0) {
                this.showIt(this.oldxpos, this.oldypos);
            }
            if (this.oldnxpos >= 0) {
                this.shownIt(this.oldnxpos, this.oldnypos);
            }
            ++this.step;
            if (this.step > this.bary.length - 1) {
                this.step = 0;
            }
            this.xpos = this.plot.calcX(this.bary[this.step].getX());
            this.ypos = this.plot.calcY(this.bary[this.step].getY());
            this.nxpos = this.plot.calcX(this.norm[this.step].getX());
            this.nypos = this.plot.calcY(this.norm[this.step].getY());
            this.showIt(this.xpos, this.ypos);
            this.shownIt(this.nxpos, this.nypos);
            this.setOldPos(this.xpos, this.ypos, this.nxpos, this.nypos);
            this.g.setColor(tmp);
        }
    }

    private void showIt(int x, int y) {
        int diameter = 8;
        this.g.setColor(PlotFit.baryColour);
        this.g.setXORMode(Color.yellow);
        this.g.fillOval(x - diameter / 2, y - diameter / 2, diameter, diameter);
    }

    private void shownIt(int x, int y) {
        int diameter = 8;
        this.g.setColor(Color.green);
        this.g.setXORMode(Color.yellow);
        this.g.fillOval(x - diameter / 2, y - diameter / 2, diameter, diameter);
    }

    public boolean setDelay(int delay) {
        this.delay = delay;
        return true;
    }

    public boolean setPosition(int x, int y) {
        this.xpos = x;
        this.ypos = y;
        return true;
    }

    private void setOldPos(int x, int y, int nx, int ny) {
        this.oldxpos = x;
        this.oldypos = y;
        this.oldnxpos = nx;
        this.oldnypos = ny;
    }
}

