/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import hipparcos.hipi.Abcissa;
import hipparcos.hipi.BadlyFormatedABstring;
import hipparcos.hipi.HIPI;
import hipparcos.tools.Constants;
import hipparcos.tools.DelimitedLine;
import hipparcos.tools.Factory;
import java.io.IOException;

public class HIPIFactory
extends Factory {
    public static HIPI get(int hipid) throws Exception {
        HIPIFactory fac = new HIPIFactory(hipid);
        HIPI h = (HIPI)fac.getObj();
        return h;
    }

    public HIPIFactory(int hipid) {
        super(hipid, "shipi", "hipiId");
    }

    protected void skipToHead() throws Exception {
        String skip = "";
        while (!skip.startsWith("IH1   |IH2")) {
            skip = this.dstream.readLine();
            if (Constants.verbose <= 5) continue;
            System.out.println("SkipToHead:" + skip);
        }
    }

    @Override
    public Object getObj() throws Exception {
        HIPI hipi = new HIPI();
        this.skipToHead();
        String str = this.dstream.readLine();
        if (Constants.verbose > 5) {
            System.out.println("Split:" + str);
        }
        DelimitedLine hinfo = new DelimitedLine(str, '|');
        try {
            hipi.ihip = hinfo.getNextInt();
            hipi.mag = hinfo.getNextDouble();
            hipi.radeg = hinfo.getNextDouble();
            hipi.decdeg = hinfo.getNextDouble();
            hipi.par = hinfo.getNextDouble();
            hipi.pma = hinfo.getNextDouble();
            hipi.pmd = hinfo.getNextDouble();
            hipi.code = hinfo.getNextString();
            hipi.nobs = hinfo.getNextInt();
            hipi.initVals();
        }
        catch (Exception e) {
            System.err.println("Bad Header Line ?");
            e.printStackTrace();
        }
        try {
            if (Constants.verbose > 5) {
                System.out.println("Reading abcissae");
            }
            str = this.dstream.readLine();
            if (Constants.verbose > 5) {
                System.out.println("skip:" + str);
            }
            boolean first = true;
            boolean finished = false;
            str = this.dstream.readLine();
            while ((str = this.dstream.readLine()) != null) {
                try {
                    if (Constants.verbose > 5) {
                        System.out.println("parsing " + str);
                    }
                    Abcissa a = new Abcissa(str);
                    a.setTobs(this.dstream.readLine());
                    this.dstream.readLine();
                    hipi.abscissae.addElement(a);
                }
                catch (BadlyFormatedABstring e) {
                    System.err.println("Discarded " + str + " Not an EP point" + e);
                }
            }
        }
        catch (IOException e) {
            System.err.println("can not load object: InputStream Error  " + e);
        }
        if (Constants.verbose > 3) {
            System.out.println("Loaded - " + hipi.ihip);
        }
        return hipi;
    }
}

