/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import hipparcos.hipi.Abcissa;
import hipparcos.hipi.Bary;
import hipparcos.hipi.Earth;
import hipparcos.hipi.HIPI;
import hipparcos.plot.DPoint;
import hipparcos.tools.VectorPosition;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class PlotFit
extends Canvas {
    static double w = 5.0;
    static Color baryColour = new Color(255, 155, 255);
    private boolean showfast = true;
    private boolean showndac = false;
    double scaleX;
    double scaleY;
    int dheight;
    DPoint min;
    DPoint max;
    DPoint[] bary;
    DPoint[] norm;
    DPoint baryStart = new DPoint();
    DPoint baryEnd = new DPoint();
    public Bary baryMover = null;
    private HIPI hipi = null;
    private int rectWidth;
    private int rectHeight;
    private int border;
    private int bottomRule;
    private int leftRule;
    private int rightRule;

    public void start() {
        if (this.baryMover != null) {
            this.baryMover.start(this.getGraphics());
        }
    }

    public void stop() {
        if (this.baryMover != null) {
            this.baryMover.stop();
        }
    }

    private void init() {
        this.rectWidth = 3;
        this.rectHeight = 3;
        this.border = 25;
        this.bottomRule = 20;
        this.rightRule = 20;
        this.leftRule = 50;
        this.setBackground(Color.white);
        this.min = new DPoint();
        this.max = new DPoint();
    }

    public PlotFit() {
        this.init();
    }

    public void hideFAST() {
        this.showfast = false;
        this.plotObservations();
    }

    public void showFAST() {
        this.showfast = true;
        this.plotObservations();
    }

    public void hideNDAC() {
        this.showndac = false;
        this.plotObservations();
    }

    public void showNDAC() {
        this.showndac = true;
        this.plotObservations();
    }

    private void plotObservations() {
        if (this.hipi != null && this.hipi.getHipNumber() != 0) {
            this.stop();
            this.repaint();
            this.start();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.hipi != null && this.hipi.getHipNumber() != 0) {
            this.plotGraph(g);
        } else {
            g.setColor(Color.red);
            g.drawString("Data Not Loaded", 20, this.getSize().height / 2);
        }
    }

    public void plotGraph(Graphics g) {
        int gHeight;
        Dimension d = this.getSize();
        int gWidth = d.width - this.leftRule - this.rightRule;
        this.dheight = gHeight = d.height - this.bottomRule;
        this.scaleX = (this.max.getX() - this.min.getX()) / (double)(gWidth - this.leftRule);
        this.scaleY = (this.max.getY() - this.min.getY()) / (double)(gHeight - this.bottomRule);
        if (this.scaleY > this.scaleX) {
            this.scaleX = this.scaleY;
        } else {
            this.scaleY = this.scaleX;
        }
        this.drawRulers(g);
        this.plotBary(g);
        this.plotNorm(g);
        this.plotObservations(g);
    }

    private void calcBaryCentric() {
        double tmin = 1989.8;
        double tmax = 1993.3;
        double dt = 0.1;
        Vector<DPoint> vbary = new Vector<DPoint>();
        Vector<DPoint> vnorm = new Vector<DPoint>();
        for (double t = tmin; t < tmax + 0.5 * dt; t += dt) {
            VectorPosition earth = Earth.where(t);
            DPoint b = new DPoint();
            DPoint n = new DPoint();
            double pa = earth.getX() * this.hipi.sinRa() - earth.getY() * this.hipi.cosRa();
            double pd = (earth.getX() * this.hipi.cosRa() + earth.getY() * this.hipi.sinRa()) * this.hipi.sinDec() - earth.getZ() * this.hipi.cosDec();
            b.setX((t - 1991.25) * this.hipi.pma);
            b.setY((t - 1991.25) * this.hipi.pmd);
            n.setX(b.getX() + this.hipi.par * pa);
            n.setY(b.getY() + this.hipi.par * pd);
            vbary.addElement(b);
            vnorm.addElement(n);
            if (!this.min.isValid() || this.min.getX() > n.getX()) {
                this.min.setX(n.getX());
            }
            if (!this.min.isValid() || this.min.getY() > n.getY()) {
                this.min.setY(n.getY());
            }
            if (!this.max.isValid() || this.max.getX() < n.getX()) {
                this.max.setX(n.getX());
            }
            if (this.max.isValid() && !(this.max.getY() < n.getY())) continue;
            this.max.setY(n.getY());
        }
        this.min.setX(this.min.getX() - 20.0);
        this.min.setY(this.min.getY() - 20.0);
        this.max.setX(this.max.getX() + 20.0);
        this.max.setY(this.max.getY() + 20.0);
        this.bary = new DPoint[vbary.size()];
        int i = 0;
        Enumeration e = vbary.elements();
        while (e.hasMoreElements()) {
            this.bary[i] = (DPoint)e.nextElement();
            ++i;
        }
        i = 0;
        this.norm = new DPoint[vnorm.size()];
        e = vnorm.elements();
        while (e.hasMoreElements()) {
            this.norm[i] = (DPoint)e.nextElement();
            ++i;
        }
        this.calcBaryEndPoints();
    }

    private double calcYpoint(double x, double x1, double y1, double x2, double y2) {
        return x * ((y2 - y1) / (x2 - x1)) + (x2 * y1 - x1 * y2) / (x2 - x1);
    }

    private void calcBaryEndPoints() {
        double x1 = this.bary[0].getX();
        double y1 = this.bary[0].getY();
        double x2 = this.bary[this.bary.length - 1].getX();
        double y2 = this.bary[this.bary.length - 1].getY();
        this.baryStart = new DPoint(this.min.getX(), this.calcYpoint(this.min.getX(), x1, y1, x2, y2));
        this.baryEnd = new DPoint(this.max.getX(), this.calcYpoint(this.max.getX(), x1, y1, x2, y2));
    }

    public int calcX(double d) {
        Double ret = new Double((double)this.leftRule + (d - this.min.getX()) / this.scaleX);
        return ret.intValue();
    }

    public int calcY(double d) {
        Double ret = new Double((d - this.min.getY()) / this.scaleY);
        return this.dheight - ret.intValue();
    }

    private void plotObservations(Graphics g) {
        Enumeration e = this.hipi.abscissae.elements();
        while (e.hasMoreElements()) {
            Abcissa a = (Abcissa)e.nextElement();
            if ((!a.consortia.startsWith("N") && !a.consortia.startsWith("n") || !this.showndac) && (!a.consortia.startsWith("F") && !a.consortia.startsWith("f") || !this.showfast)) continue;
            if (a.consortia.startsWith("N") || a.consortia.startsWith("n")) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.blue);
            }
            VectorPosition earth = Earth.where(1991.25 + a.tobs);
            double pa = earth.getX() * this.hipi.sinRa() - earth.getY() * this.hipi.cosRa();
            double pd = (earth.getX() * this.hipi.cosRa() + earth.getY() * this.hipi.sinRa()) * this.hipi.sinDec() - earth.getZ() * this.hipi.cosDec();
            DPoint fit = new DPoint(a.tobs * this.hipi.pma + this.hipi.par * pa, a.tobs * this.hipi.pmd + this.hipi.par * pd);
            DPoint obs = new DPoint(fit.getX() + a.a8 * a.a3, fit.getY() + a.a8 * a.a4);
            if (a.consortia.startsWith("f") || a.consortia.startsWith("n")) {
                this.plotOpenPoint(g, obs);
                continue;
            }
            this.plotPoint(g, fit);
            this.plotLine(g, obs, fit);
            DPoint barStart = new DPoint(obs.getX() + w * a.a4, obs.getY() - w * a.a3);
            DPoint barEnd = new DPoint(obs.getX() - w * a.a4, obs.getY() + w * a.a3);
            this.plotLine(g, barStart, barEnd);
        }
    }

    private void plotPoint(Graphics g, DPoint p) {
        int diameter = 4;
        g.fillOval(this.calcX(p.getX()) - diameter / 2, this.calcY(p.getY()) - diameter / 2, diameter, diameter);
    }

    private void plotOpenPoint(Graphics g, DPoint p) {
        int diameter = 4;
        g.drawOval(this.calcX(p.getX()) - diameter / 2, this.calcY(p.getY()) - diameter / 2, diameter, diameter);
    }

    private void plotLine(Graphics g, DPoint p1, DPoint p2) {
        g.drawLine(this.calcX(p1.getX()), this.calcY(p1.getY()), this.calcX(p2.getX()), this.calcY(p2.getY()));
    }

    private void plotBary(Graphics g) {
        g.setColor(baryColour);
        this.plotLine(g, this.baryStart, this.baryEnd);
    }

    private void plotNorm(Graphics g) {
        Color tmp = g.getColor();
        int diameter = 4;
        double dt = 0.01;
        double tmin = 1989.8;
        double tmax = 1993.3;
        g.setColor(Color.green);
        for (double t = tmin; t < tmax + 0.5 * dt; t += dt) {
            VectorPosition earth = Earth.where(t);
            DPoint b = new DPoint();
            double pa = earth.getX() * this.hipi.sinRa() - earth.getY() * this.hipi.cosRa();
            double pd = (earth.getX() * this.hipi.cosRa() + earth.getY() * this.hipi.sinRa()) * this.hipi.sinDec() - earth.getZ() * this.hipi.cosDec();
            b.setX((t - 1991.25) * this.hipi.pma);
            b.setY((t - 1991.25) * this.hipi.pmd);
            g.fillOval(this.calcX(b.getX() + this.hipi.par * pa) - diameter / 2, this.calcY(b.getY() + this.hipi.par * pd) - diameter / 2, diameter, diameter);
        }
        g.setColor(tmp);
    }

    private void drawRulers(Graphics g) {
        int posTick;
        int tick;
        int ystep = 10;
        int xstep = 10;
        int cShift = 9;
        Float stF = new Float(this.max.getY() - this.max.getY() % (double)ystep);
        int highY = stF.intValue();
        stF = new Float(this.min.getY() - this.min.getY() % (double)ystep);
        int lowY = stF.intValue();
        int posHighY = this.calcY(highY) + cShift / 2;
        int posLowY = this.calcY(lowY) + cShift / 2;
        ystep = this.getStep(highY - lowY);
        stF = new Float(this.max.getX() - this.max.getX() % (double)ystep);
        int highX = stF.intValue();
        stF = new Float(this.min.getX() - this.min.getX() % (double)xstep);
        int lowX = stF.intValue();
        int posHighX = this.calcX(highX) - cShift / 2;
        int posLowX = this.calcX(lowX) - cShift;
        xstep = this.getStep(highX - lowX);
        g.setColor(Color.black);
        String scaleBanner = new String("Tick Scale: ");
        String tmp = new String("(mas) Dec ");
        scaleBanner = scaleBanner + ystep + tmp;
        tmp = new String("(mas) RA");
        scaleBanner = scaleBanner + xstep + tmp;
        g.drawString(scaleBanner, 1, 12);
        g.drawString("Dec", 1, 50);
        Dimension d = this.getSize();
        g.drawString("RA", d.width - 30, d.height - cShift);
        g.drawLine(this.leftRule - 1, this.border, this.leftRule - 1, d.height - this.bottomRule);
        g.drawLine(this.leftRule - 1, d.height - this.bottomRule, d.width - this.rightRule, d.height - this.bottomRule);
        g.drawString("" + lowY, 3, posLowY);
        g.drawString("" + highY, 3, posHighY);
        g.drawString("" + lowX, posLowX, d.height - cShift / 2);
        g.drawString("" + highX, posHighX, d.height - cShift / 2);
        int endTick = highY - highY % ystep;
        for (tick = lowY - lowY % ystep; tick <= endTick; tick += ystep) {
            posTick = this.calcY(tick);
            g.drawLine(this.leftRule - 5, posTick, this.leftRule, posTick);
            if (tick != 0) continue;
            g.drawString("" + tick, 3, posTick + cShift / 2);
        }
        endTick = highX - highX % xstep;
        for (tick = lowX - lowX % xstep; tick <= endTick; tick += xstep) {
            posTick = this.calcX(tick);
            g.drawLine(posTick, d.height - this.bottomRule, posTick, d.height - this.bottomRule + 5);
            if (tick != 0) continue;
            g.drawString("" + tick, posTick - cShift / 2, d.height - cShift / 2);
        }
    }

    public void setHipi(HIPI obj) {
        this.stop();
        this.hipi = obj;
        this.min = new DPoint();
        this.max = new DPoint();
        this.calcBaryCentric();
        this.repaint();
        if (this.baryMover == null) {
            this.baryMover = new Bary(this.getGraphics(), this);
        }
        if (this.baryMover != null) {
            this.baryMover.setBary(this.bary, this.norm);
        }
        this.start();
    }

    public HIPI getHipi() {
        return this.hipi;
    }

    private int getStep(int range) {
        int ret = 10;
        if (range >= 200) {
            ret = 100;
        }
        return ret;
    }
}

