/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import hipparcos.hipi.Abcissa;
import hipparcos.hipi.HIPI;
import hipparcos.hipi.HIPIFactory;
import hipparcos.hipi.Legend;
import hipparcos.hipi.PhasePanel;
import hipparcos.hipi.PlotFit;
import hipparcos.plot.DPoint;
import hipparcos.plot.Histogram;
import hipparcos.plot.PhasePlot;
import hipparcos.plot.SimplePlot;
import hipparcos.tools.Browser;
import hipparcos.tools.Constants;
import hipparcos.tools.HIPproperties;
import hipparcos.tools.MainFrame;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;

public class PlotHipi
extends Applet
implements ActionListener {
    private HIPI hipi = new HIPI();
    private PlotFit theCurve;
    private Label info1;
    private Label info2;
    private TextField hipfield;
    private String dataDir;
    private double step = 1.0;
    private boolean started = false;
    private Button getStats;
    private Button getTimeStats;
    private CardLayout cards = new CardLayout();
    private boolean stated = false;
    private Histogram residualn;
    private Histogram residualf;
    private Histogram stdern;
    private Histogram stderf;
    private Histogram normErrn;
    private Histogram normErrf;
    private SimplePlot timeNormn;
    private SimplePlot timeNormf;
    private PhasePlot phaseNormn;
    private PhasePlot phaseNormf;
    private Panel mainPanel;
    private PhasePanel phase;

    @Override
    public void init() {
        Browser.setAppletContext(this.getAppletContext());
        this.setLayout(new BorderLayout());
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(this.cards);
        this.add("Center", this.mainPanel);
        Panel stats = new Panel();
        stats.setLayout(new GridLayout(2, 3));
        this.residualf = new Histogram("Residual (mas)", "FAST", -10, 10, 1.0, Color.blue);
        stats.add(this.residualf);
        this.stderf = new Histogram("Standard Error (mas) [bin 0.5]", "FAST", 0, 10, 0.5, Color.blue);
        stats.add(this.stderf);
        this.normErrf = new Histogram("Normalised Error [bin 0.5]", "FAST", -5, 5, 0.5, Color.blue);
        stats.add(this.normErrf);
        this.residualn = new Histogram("Residual (mas)", "NDAC", -10, 10, 1.0, Color.red);
        stats.add(this.residualn);
        this.stdern = new Histogram("Standard Error (mas) [bin 0.5]", "NDAC", 0, 10, 0.5, Color.red);
        stats.add(this.stdern);
        this.normErrn = new Histogram("Normalised Error [bin 0.5]", "NDAC", -5, 5, 0.5, Color.red);
        stats.add(this.normErrn);
        this.mainPanel.add("stats", stats);
        Panel timestats = new Panel();
        timestats.setLayout(new GridLayout(2, 2));
        this.timeNormf = new SimplePlot("Normalised Error (mas) over time", "FAST", 1989.75, 1993.25, -5.0, 5.0, Color.blue);
        timestats.add(this.timeNormf);
        this.phaseNormf = new PhasePlot("Normalised Error (mas) Folded", "FAST", -5.0, 5.0, Color.blue);
        timestats.add(this.phaseNormf);
        this.timeNormn = new SimplePlot("Normalised Error (mas) over time", "NDAC", 1989.75, 1993.25, -5.0, 5.0, Color.red);
        timestats.add(this.timeNormn);
        this.phaseNormn = new PhasePlot("Normalised Error (mas) Folded", "NDAC", -5.0, 5.0, Color.red);
        timestats.add(this.phaseNormn);
        Panel stats2 = new Panel();
        stats2.setLayout(new BorderLayout());
        stats2.add("Center", timestats);
        this.phase = new PhasePanel("Enter required folding period (years):", "0.5000", this);
        stats2.add("South", this.phase);
        this.mainPanel.add("timestats", stats2);
        Panel info = new Panel();
        info.setLayout(new GridLayout(2, 1));
        this.info1 = new Label("No Data ........");
        this.info2 = new Label("........");
        info.add("1", this.info1);
        info.add("2", this.info2);
        this.add("North", info);
        Panel curvePanel = new Panel();
        curvePanel.setLayout(new BorderLayout());
        this.theCurve = new PlotFit();
        curvePanel.add("Center", this.theCurve);
        curvePanel.add("East", new Legend(PlotFit.baryColour));
        this.mainPanel.add("curve", curvePanel);
        this.cards.show(this.mainPanel, "curve");
        Panel p = new Panel();
        Label t2 = new Label("HIP");
        p.add("West", t2);
        this.hipfield = new TextField(7);
        this.hipfield.addActionListener(this);
        p.add("East", this.hipfield);
        Button upButton = new Button("prev");
        p.add("West", upButton);
        Button downButton = new Button("next");
        p.add("East", downButton);
        Checkbox FAST = new Checkbox("FAST", null, true);
        this.theCurve.showFAST();
        p.add("East", FAST);
        Checkbox NDAC = new Checkbox("NDAC", null, false);
        this.theCurve.hideNDAC();
        p.add("East", NDAC);
        Button getInfo = new Button("Get ASCII Data");
        p.add("East", getInfo);
        this.getStats = new Button("Statistics 1");
        p.add("East", this.getStats);
        this.getTimeStats = new Button("Statistics 2");
        p.add("East", this.getTimeStats);
        this.add("South", p);
        try {
            int id = this.checkForId();
            this.hipi = HIPIFactory.get(id);
            this.newhipi();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int checkForId() throws Exception {
        String idString = this.getParameter("id");
        return Integer.parseInt(idString.trim());
    }

    @Override
    public boolean action(Event evt, Object obj) {
        switch (evt.id) {
            case 1001: {
                String label;
                Component theButton;
                if (evt.target instanceof Checkbox) {
                    theButton = (Checkbox)evt.target;
                    label = ((Checkbox)theButton).getLabel();
                    boolean state = ((Checkbox)theButton).getState();
                    if (label == "FAST") {
                        if (state) {
                            this.theCurve.showFAST();
                        } else {
                            this.theCurve.hideFAST();
                        }
                    }
                    if (label == "NDAC") {
                        if (state) {
                            this.theCurve.showNDAC();
                        } else {
                            this.theCurve.hideNDAC();
                        }
                    }
                }
                if (evt.target instanceof TextField) {
                    Integer hipid = Integer.valueOf((String)evt.arg);
                    try {
                        this.hipi = HIPIFactory.get(hipid);
                        this.newhipi();
                    }
                    catch (Exception e) {
                        this.info1.setText("Bad Hipnumber " + hipid.toString());
                    }
                }
                if (!(evt.target instanceof Button)) break;
                theButton = (Button)evt.target;
                label = ((Button)theButton).getLabel();
                int hipid = this.hipi.getHipNumber();
                boolean found = false;
                if (label == "Statistics 2") {
                    if (this.hipi.getHipNumber() == 0) {
                        this.info1.setText("Enter a HIP number first");
                    } else {
                        this.theCurve.stop();
                        this.cards.show(this.mainPanel, "timestats");
                        this.provideStats();
                        this.getStats.setLabel("Statistics 1");
                        this.getTimeStats.setLabel("Show Curve");
                    }
                }
                if (label == "Show Curve") {
                    if (this.hipi.getHipNumber() == 0) {
                        this.info1.setText("Enter a HIP number first");
                    } else {
                        this.cards.show(this.mainPanel, "curve");
                        this.theCurve.start();
                        this.getStats.setLabel("Statistics 1");
                        this.getTimeStats.setLabel("Statistics 2");
                    }
                }
                if (label == "Statistics 1") {
                    if (this.hipi.getHipNumber() == 0) {
                        this.info1.setText("Enter a HIP number first");
                    } else {
                        this.theCurve.stop();
                        this.cards.show(this.mainPanel, "stats");
                        this.provideStats();
                        this.getStats.setLabel("Show Curve");
                        this.getTimeStats.setLabel("Statistics 2");
                    }
                }
                if (label == "Get ASCII Data") {
                    if (this.hipi.getHipNumber() == 0) {
                        this.info1.setText("Enter a HIP number first");
                    } else {
                        Browser.goTo(this.makeUrl());
                    }
                }
                if (label == "next") {
                    if (hipid >= 120415) {
                        hipid = 0;
                    }
                    if (hipid == 120404) {
                        hipid = 120414;
                    }
                    if (hipid == 118322) {
                        hipid = 120000;
                    }
                    if (hipid == 120006) {
                        hipid = 120026;
                    }
                    if (hipid == 120027) {
                        hipid = 120045;
                    }
                    if (hipid == 120047) {
                        hipid = 120070;
                    }
                    if (hipid == 120082) {
                        hipid = 120120;
                    }
                    while (!found) {
                        ++hipid;
                        try {
                            this.hipi = HIPIFactory.get(hipid);
                            found = this.hipi.getHipNumber() > 0;
                        }
                        catch (Exception exception) {}
                    }
                    this.newhipi();
                }
                if (label != "prev") break;
                if (hipid <= 1) {
                    hipid = 120416;
                }
                if (hipid == 120415) {
                    hipid = 120405;
                }
                if (hipid == 120000) {
                    hipid = 118321;
                }
                if (hipid == 120026) {
                    hipid = 120007;
                }
                if (hipid == 120046) {
                    hipid = 120027;
                }
                if (hipid == 120071) {
                    hipid = 120047;
                }
                if (hipid == 120121) {
                    hipid = 120083;
                }
                while (!found) {
                    --hipid;
                    try {
                        this.hipi = HIPIFactory.get(hipid);
                        found = this.hipi.getHipNumber() > 0;
                    }
                    catch (Exception exception) {}
                }
                this.newhipi();
            }
        }
        return true;
    }

    private void provideStats() {
        if (!this.stated) {
            this.residualn.resetGraph();
            this.stdern.resetGraph();
            this.normErrn.resetGraph();
            this.residualf.resetGraph();
            this.stderf.resetGraph();
            this.normErrf.resetGraph();
            this.timeNormf.resetGraph();
            this.timeNormn.resetGraph();
            this.phaseNormf.resetGraph();
            this.phaseNormn.resetGraph();
            Enumeration e = this.hipi.abscissae.elements();
            while (e.hasMoreElements()) {
                Abcissa a = (Abcissa)e.nextElement();
                double normErr = a.a8 / a.a9;
                DPoint p = new DPoint(1991.25 + a.tobs, normErr);
                if (a.consortia.startsWith("N")) {
                    this.residualn.addOccurence(a.a8);
                    this.stdern.addOccurence(a.a9);
                    this.normErrn.addOccurence(normErr);
                    this.timeNormn.addPoint(p);
                    this.phaseNormn.addPoint(p);
                }
                if (!a.consortia.startsWith("F")) continue;
                this.residualf.addOccurence(a.a8);
                this.stderf.addOccurence(a.a9);
                this.normErrf.addOccurence(normErr);
                this.phaseNormf.addPoint(p);
                this.timeNormf.addPoint(p);
            }
            this.stated = true;
        }
    }

    private void newhipi() {
        Integer n = new Integer(this.hipi.getHipNumber());
        this.hipfield.setText(n.toString());
        this.info1.setText(this.hipi.getInfoText1());
        this.info2.setText(this.hipi.getInfoText2());
        this.cards.show(this.mainPanel, "curve");
        this.getStats.setLabel("Statistics 1");
        this.getTimeStats.setLabel("Statistics 2");
        this.theCurve.setHipi(this.hipi);
        this.stated = false;
    }

    @Override
    public String getAppletInfo() {
        return "Abcissae fit  by  Wil , Lennart Lindegren & Michael Perrymann";
    }

    public URL makeUrl() {
        try {
            String theUrl = HIPproperties.getProperty("hipurl");
            theUrl = theUrl + "?hipiId=" + this.hipi.getHipNumber();
            if (Constants.verbose > 3) {
                System.out.println(theUrl);
            }
            return new URL(theUrl);
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public double getPhase() {
        return this.phaseNormn.getPhase();
    }

    public void setPhase(double phase) {
        this.phaseNormn.setPhase(phase);
        this.phaseNormf.setPhase(phase);
    }

    public static void main(String[] argv) {
        Browser.setMainFrame();
        new MainFrame(new PlotHipi(), argv, 730, 570);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof TextField) {
            Integer hipid = Integer.valueOf(this.hipfield.getText());
            try {
                this.hipi = HIPIFactory.get(hipid);
                this.newhipi();
            }
            catch (Exception e) {
                this.info1.setText("Bad Hipnumber " + hipid.toString());
            }
        }
    }
}

