/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.plot;

import hipparcos.plot.DPoint;
import hipparcos.plot.SimplePlot;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;

public class PhasePlot
extends SimplePlot {
    private double phase;

    public PhasePlot(String xlabel, String ylabel, double lowY, double highY, Color col) {
        super(xlabel, ylabel, 0.0, 1.5, lowY, highY, col);
        this.xstep = 0.1;
        this.numberStep = 1;
        this.phase = 0.5;
    }

    @Override
    public void resetGraph() {
        super.resetGraph();
        this.xstep = 0.5;
        this.numberStep = 1;
    }

    @Override
    public void plotGraph(Graphics g) {
        if (this.gotOne) {
            if (this.plotZeroLine) {
                this.plotZero(g);
            }
            g.setColor(this.plotcol);
            Enumeration e = this.points.elements();
            while (e.hasMoreElements()) {
                DPoint op = (DPoint)e.nextElement();
                DPoint p = new DPoint(op);
                double x = p.getX() % this.phase * (1.0 / this.phase);
                p.setX(x);
                this.plotPoint(p, g);
                if (!(p.getX() <= 0.5)) continue;
                p.setX(p.getX() + 1.0);
                this.plotPoint(p, g);
            }
        } else {
            g.setColor(Color.red);
            g.drawString(" No data", 30, this.getSize().height / 2);
        }
    }

    public void setPhase(double phase) {
        this.phase = phase;
        this.repaint();
    }

    public double getPhase() {
        return this.phase;
    }
}

