/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky;

import hipparcos.sky.Position;
import hipparcos.sky.Star2D;
import hipparcos.tools.Star;
import hipparcos.tools.StarStore;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Label;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class SkyArea
extends Canvas
implements StarStore {
    private Vector stars = null;
    private int firstTyc = 0;
    private String gap = new String("       ");
    private double alpha;
    private double delta;
    private double tol;
    private double scale = 0.0;
    private boolean inited = false;
    private Star2D lastSelected = null;
    private boolean viewHipOnly = false;
    private boolean tails = false;
    private Label infoRA = null;
    private Label infoDEC = null;
    private Label infoHMS = null;
    private Label infoDMS = null;
    DecimalFormat raf = new DecimalFormat("000.00000000");
    DecimalFormat decf = new DecimalFormat("00.00000000");

    @Override
    public Iterator getStars() {
        return this.stars.iterator();
    }

    public SkyArea() {
        this.setBackground(Color.black);
    }

    public SkyArea(double alpha, double delta, double tol) {
        this.setBackground(Color.black);
        this.inited = true;
        this.alpha = alpha;
        this.delta = delta;
        this.tol = tol;
        this.stars = new Vector();
        this.scale = (double)this.getSize().width / (tol * 2.0);
    }

    public void init(double alpha, double delta, double tol) {
        this.inited = true;
        this.alpha = alpha;
        this.delta = delta;
        this.tol = tol;
        this.firstTyc = 0;
        this.stars = new Vector();
        this.getGraphics().setColor(Color.black);
        this.getGraphics().setPaintMode();
        this.getGraphics().fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.scale = (double)this.getSize().width / (tol * 2.0);
    }

    public void infoInit(Label RA, Label DEC, Label HMS, Label DMS) {
        this.infoRA = RA;
        this.infoDEC = DEC;
        this.infoHMS = HMS;
        this.infoDMS = DMS;
    }

    @Override
    public void paint(Graphics g) {
        this.setBackground(Color.black);
        if (this.inited) {
            double tmpscale = (double)this.getSize().width / (this.tol * 2.0);
            if (tmpscale != this.scale) {
                this.plotAll(tmpscale);
            } else {
                this.plotAll();
            }
        }
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public double getDelta() {
        return this.delta;
    }

    @Override
    public double getTol() {
        return this.tol;
    }

    @Override
    public void addStar(Star hstar) {
        Star2D star = new Star2D(hstar);
        this.plotStar(star);
        this.stars.addElement(star);
        if (this.firstTyc == 0 && star.getType().startsWith("T")) {
            this.firstTyc = this.stars.size() - 1;
        }
    }

    private void plotStar(Star2D star) {
        int x = this.whichX(star.getAlpha());
        int y = this.whichY(star.getDelta());
        star.plot(this.getGraphics(), x, y);
    }

    private void moveStar(Star2D star, int step) {
        int startx = this.whichX(star.getAlpha());
        int starty = this.whichX(star.getDelta());
        int x = this.whichX(star.getAlpha() + star.getMuAlpha(step));
        int y = this.whichY(star.getDelta() + star.getMuDelta(step));
        Graphics g = this.getGraphics();
        star.move(g, x, y, this.getSize().width, this.tails);
    }

    public void moveStars(int step) {
        if (this.inited) {
            Enumeration e = this.stars.elements();
            while (e.hasMoreElements()) {
                Star2D star = (Star2D)e.nextElement();
                if (this.viewHipOnly && (!this.viewHipOnly || !star.inHIP())) continue;
                this.moveStar(star, step);
            }
        }
    }

    public void plotAll() {
        if (this.inited) {
            Enumeration e = this.stars.elements();
            while (e.hasMoreElements()) {
                Star2D star = (Star2D)e.nextElement();
                if (this.viewHipOnly && (!this.viewHipOnly || !star.inHIP())) continue;
                star.plot(this.getGraphics());
            }
        }
    }

    public void plotAll(double scale) {
        if (this.inited) {
            this.scale = scale;
            System.out.println("Rescaled ");
            Enumeration e = this.stars.elements();
            while (e.hasMoreElements()) {
                Star2D star = (Star2D)e.nextElement();
                this.plotStar(star);
            }
        }
    }

    public void replotAll(double thres) {
        if (this.inited) {
            Enumeration e = this.stars.elements();
            while (e.hasMoreElements()) {
                Star2D star = (Star2D)e.nextElement();
                if (!(star.getMag() > thres)) continue;
                star.unplot(this.getGraphics(), false);
            }
            this.plotAll();
        }
    }

    public Star2D findStarNear(int x, int y) {
        if (this.inited) {
            Star2D star = null;
            int right = this.stars.size() - 1;
            star = this.findStarNear(x, y, 0, this.firstTyc - 1);
            if (star == null) {
                star = this.findStarNear(x, y, this.firstTyc, right);
            }
            if (star != null) {
                return star;
            }
        }
        return null;
    }

    public Star2D findStarNear(int x, int y, int sleft, int sright) {
        boolean finished = false;
        boolean found = false;
        Star2D star = null;
        int left = sleft;
        int right = sright;
        int mid = 0;
        while (!found && !finished) {
            mid = (left + right) / 2;
            star = (Star2D)this.stars.elementAt(mid);
            found = star.near(x, y);
            boolean bl = finished = left == mid && right == mid || left > right || star.near(x + 5, y);
            if (star.before(x + 5, y)) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        finished = false;
        while (!finished) {
            star = (Star2D)this.stars.elementAt(mid);
            found = star.near(x, y);
            finished = found || star.after(x - 5, y) || ++mid >= sright;
        }
        if (found) {
            return star;
        }
        return null;
    }

    public Star2D getLastSelected() {
        return this.lastSelected;
    }

    public void setViewHipOnly() {
        this.viewHipOnly = true;
        this.repaint();
    }

    public void setTails() {
        this.tails = true;
    }

    public void unSetTails() {
        this.tails = false;
        this.repaint();
    }

    public void unSetViewHipOnly() {
        this.viewHipOnly = false;
        this.repaint();
    }

    @Override
    public boolean mouseDown(Event evt, int x, int y) {
        Star2D astar = this.findStarNear(x, y);
        if (astar != null) {
            astar.showDetails(this.getGraphics(), this.getSize().width);
            this.lastSelected = astar;
        }
        return true;
    }

    @Override
    public boolean mouseMove(Event evt, int x, int y) {
        Position pos = new Position(this.whichAlpha(x), this.whichDelta(y));
        if (this.infoRA != null) {
            this.infoRA.setText(this.raf.format(pos.getRa()));
        }
        if (this.infoDEC != null) {
            this.infoDEC.setText(this.decf.format(pos.getDec()));
        }
        if (this.infoHMS != null) {
            this.infoHMS.setText(pos.HMS());
        }
        if (this.infoDMS != null) {
            this.infoDMS.setText(pos.DMS());
        }
        return true;
    }

    public double whichAlpha(int x) {
        double ret = 0.0;
        if (this.inited && (ret = this.alpha + this.tol - (double)x / this.scale) < 0.0) {
            ret += 360.0;
        }
        return ret;
    }

    public double whichDelta(int y) {
        double ret = 0.0;
        if (this.inited) {
            ret = this.delta + this.tol - (double)y / this.scale;
        }
        return ret;
    }

    public int whichX(double somealpha) {
        double adjustedAlpha = this.alpha - somealpha + this.tol;
        if (adjustedAlpha < 0.0) {
            adjustedAlpha += 360.0;
        }
        if (adjustedAlpha > this.tol * 2.0) {
            adjustedAlpha -= 360.0;
        }
        int x = (int)Math.round(adjustedAlpha * this.scale);
        return x;
    }

    public int whichY(double somedelta) {
        double adjustedDelta = this.delta - somedelta + this.tol;
        if (adjustedDelta < 0.0) {
            adjustedDelta += 90.0;
        }
        if (adjustedDelta > this.tol * 2.0) {
            adjustedDelta -= 90.0;
        }
        int y = (int)Math.round(adjustedDelta * this.scale);
        return y;
    }

    public Dimension getPreferedSize() {
        return new Dimension(500, 500);
    }
}

