/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky;

import hipparcos.sky.Mag;
import hipparcos.tools.Star;
import java.awt.Color;
import java.awt.Graphics;

public class Star2D
extends Star {
    public static Color HipColor = Color.red;
    public static Color TycColor = Color.white;
    public static Color HTColor = Color.cyan;
    private static double thresholdMag = 999.0;
    private static boolean ignoreDiff = false;
    private static int yearStep = 100;
    protected Mag gmag = new Mag(this.getMag());
    protected int x;
    protected int y;
    protected int mux;
    protected int muy;
    protected boolean shown = false;

    public static void setThreshold(double threshold) {
        thresholdMag = threshold;
    }

    public static double getThreshold() {
        return thresholdMag;
    }

    public void init() {
        this.id = null;
    }

    public Star2D(Star star) {
        super(star);
    }

    public Star2D(String str) throws Exception {
        super(str);
    }

    public Mag getMag2D() {
        return this.gmag;
    }

    public void plot(Graphics g, int x, int y) {
        this.x = x;
        this.y = y;
        this.plot(g);
    }

    public void plot(Graphics g) {
        int diameter = this.gmag.getPixelDiameter();
        Color tmp = g.getColor();
        if (ignoreDiff) {
            g.setColor(TycColor);
        } else if (this.type.startsWith("H")) {
            g.setColor(HipColor);
        } else if (this.inHIPnTYC) {
            g.setColor(HTColor);
        } else {
            g.setColor(TycColor);
        }
        if (this.getMag() <= thresholdMag) {
            g.fillOval(this.x - diameter / 2, this.y - diameter / 2, diameter, diameter);
        }
        g.setColor(tmp);
    }

    public void unplot(Graphics g, boolean tails) {
        int diameter = this.gmag.getPixelDiameter();
        Color tmp = g.getColor();
        if (tails && this.getMag() <= thresholdMag) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(Color.black);
        }
        g.fillOval(this.x - diameter / 2, this.y - diameter / 2, diameter, diameter);
        g.setColor(tmp);
    }

    public void showDetails(Graphics g, int rightLimit) {
        int txof = 105;
        if (this.type.startsWith("T")) {
            txof = 155;
        }
        if (this.x + txof < rightLimit && this.y > 18) {
            this.showDetails(g);
        } else {
            int newx = this.x;
            int newy = this.y;
            if (this.y <= 18) {
                newy = 18;
            }
            if (this.x + txof > rightLimit) {
                newx = this.x - (this.x + txof - rightLimit);
            }
            this.showDetails(g, newx, newy);
        }
        this.shown = !this.shown;
    }

    public void showDetails(Graphics g) {
        g.setXORMode(Color.green);
        g.drawString(this.shortInfo(), this.x + 1, this.y - 1);
    }

    public void showDetails(Graphics g, int x, int y) {
        g.setXORMode(Color.green);
        g.drawString(this.shortInfo(), x, y);
    }

    public boolean near(int x, int y) {
        boolean ret = false;
        int allow = this.gmag.getPixelDiameter() / 2;
        ret = x >= this.x - allow && x <= this.x + allow && y >= this.y - allow && y <= this.y + allow;
        return ret;
    }

    public boolean before(int x, int y) {
        boolean ret = false;
        ret = x == this.x ? y < this.y : x < this.x;
        return ret;
    }

    public boolean after(int x, int y) {
        boolean ret = false;
        ret = x == this.x ? y > this.y : x > this.x;
        return ret;
    }

    public void move(Graphics g, int x, int y, int rightLimit, boolean tails) {
        if (x != this.x || y != this.y) {
            boolean details = this.shown;
            int diameter = this.gmag.getPixelDiameter();
            if (details) {
                this.showDetails(g, rightLimit);
            }
            this.unplot(g, tails);
            this.plot(g, x, y);
            if (details) {
                this.showDetails(g, rightLimit);
            }
        }
    }

    @Override
    public double getMuAlpha(int step) {
        return (double)yearStep * (this.getMuAlpha() * (double)step / 3600000.0);
    }

    @Override
    public double getMuDelta(int step) {
        return (double)yearStep * (this.getMuDelta() * (double)step / 3600000.0);
    }

    public static boolean setIgnoreDiff() {
        ignoreDiff = true;
        return true;
    }

    public static boolean unSetIgnoreDiff() {
        ignoreDiff = false;
        return false;
    }

    public static boolean setYearStep(int ys) {
        yearStep = ys;
        return true;
    }

    public static int yearStep() {
        return yearStep;
    }
}

