/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky3d;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import hipparcos.sky3d.Star3D;
import hipparcos.tools.Constants;
import java.awt.Dimension;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ColourScale
extends Canvas3D {
    private BranchGroup scene = this.createSceneGraph();
    private TransformGroup objTrans;
    private TransformGroup objScale;
    private SimpleUniverse uni = new SimpleUniverse((Canvas3D)this);
    private int scale = 2;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.objTrans = new TransformGroup();
        this.objScale = new TransformGroup();
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        this.objScale.addChild((Node)this.objTrans);
        objRoot.addChild((Node)this.objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 50.0);
        Color3f bgColor = new Color3f(0.01f, 0.01f, 0.1f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        AmbientLight ambientLightNode = new AmbientLight();
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(0.8f, 0.8f, 0.8f);
        Vector3f light1Direction = new Vector3f(4.0f, -7.0f, -12.0f);
        Color3f light2Color = new Color3f(0.3f, 0.3f, 0.3f);
        Vector3f light2Direction = new Vector3f(-6.0f, -2.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        return objRoot;
    }

    public ColourScale() {
        super(null);
    }

    protected void setScale(int w) {
        Transform3D scale = new Transform3D();
        float sc = (float)(0.8 / (double)w);
        this.scale = 2;
        scale.setScale((double)sc);
        System.out.println("Scale " + sc + " w is " + w);
        this.objScale.setTransform(scale);
    }

    protected void populate() {
        float w = 0.5f;
        double gap = w * 5.0f;
        for (int col = 0; col < Constants.colours.length; ++col) {
            Appearance ap = Star3D.sgetAppearance(col);
            Transform3D mat = new Transform3D();
            TransformGroup g = new TransformGroup(mat);
            double y = gap * (double)col - gap / 2.0 * (double)(Constants.colours.length - 1);
            float z = -w;
            mat.set(new Vector3d(0.0, (double)((float)y), (double)z));
            System.out.println(" y:" + y + " z:" + z);
            g.setTransform(mat);
            g.addChild((Node)new Sphere(w, 33, 15, ap));
            this.objTrans.addChild((Node)g);
        }
    }

    public void showScene() {
        this.populate();
        this.scene.compile();
        this.uni.addBranchGraph(this.scene);
        this.uni.getViewingPlatform().setNominalViewingTransform();
    }

    public Dimension getPreferredSize() {
        return new Dimension(50, 100);
    }
}

