/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky3d;

import hipparcos.sky3d.RotateAble;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.media.j3d.Alpha;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4f;

public class RotatePanel
extends Panel
implements ItemListener,
ActionListener {
    protected RotateAble scene;
    protected Button rotBut;
    protected Alpha alpha;
    protected Choice choice;
    protected Checkbox x;
    protected Checkbox y;
    protected Checkbox z;

    protected void init() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridy = -1;
        c.gridx = 0;
        c.ipadx = 0;
        c.ipady = 0;
        this.rotBut = new Button("Rotate");
        this.rotBut.setForeground(Color.red);
        this.rotBut.addActionListener(this);
        this.choice = new Choice();
        this.choice.addItem("1");
        this.choice.addItem("2");
        this.choice.addItem("3");
        this.choice.addItem("4");
        this.choice.addItem("5");
        this.choice.addItem("10");
        this.choice.addItem("20");
        this.choice.addItem("30");
        this.choice.addItem("40");
        this.choice.addItem("50");
        this.choice.addItem("100");
        this.choice.addItem("200");
        this.choice.addItem("300");
        this.choice.addItem("400");
        this.choice.addItem("500");
        this.choice.select("10");
        this.choice.addItemListener(this);
        Panel fac = new Panel();
        fac.setLayout(new GridLayout(1, 2));
        Label delay = new Label("Delay:");
        delay.setForeground(Color.blue);
        fac.add(delay);
        fac.add(this.choice);
        fac.setBackground(Color.white);
        Panel axis = new Panel();
        axis.setBackground(Color.white);
        CheckboxGroup cbg = new CheckboxGroup();
        this.x = new Checkbox("X", cbg, false);
        this.x.setForeground(Color.blue);
        this.x.addItemListener(this);
        this.y = new Checkbox("Y", cbg, true);
        this.y.setForeground(Color.blue);
        this.y.addItemListener(this);
        this.z = new Checkbox("Z", cbg, false);
        this.z.setForeground(Color.blue);
        this.z.addItemListener(this);
        axis.add(this.x);
        axis.add(this.y);
        axis.add(this.z);
        gridbag.setConstraints(this.rotBut, c);
        this.add(this.rotBut);
        gridbag.setConstraints(axis, c);
        this.add(axis);
        gridbag.setConstraints(fac, c);
        this.add(fac);
        this.setBackground(Color.white);
    }

    public void setScene(RotateAble scene) {
        this.scene = scene;
    }

    public void setFactor(int width) {
        int factor = 100;
        if (width < 50) {
            factor = 50;
        }
        if (width < 40) {
            factor = 40;
        }
        if (width < 30) {
            factor = 30;
        }
        if (width < 20) {
            factor = 20;
        }
        if (width < 15) {
            factor = 10;
        }
        this.choice.select("" + factor);
        this.setSpeed(factor);
    }

    protected void setAxis(int x, int y, int z) {
        RotationInterpolator rot;
        if (this.scene != null && (rot = this.scene.getRotationInterpolator()) != null) {
            Transform3D axis = new Transform3D();
            axis.set(new AxisAngle4f((float)x, (float)y, (float)z, 2.0f));
            rot.setAxisOfRotation(axis);
        }
    }

    protected void setSpeed(int factor) {
        this.alpha = new Alpha(-1, (long)(factor * 1000));
    }

    public RotatePanel() {
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == "Rotate") {
            this.start();
        }
        if (label == "Stop") {
            this.stop();
        }
    }

    public void start() {
        this.rotBut.setLabel("Stop");
        this.scene.getRotationInterpolator().setAlpha(this.alpha);
    }

    public void stop() {
        this.rotBut.setLabel("Rotate");
        this.scene.getRotationInterpolator().setAlpha(null);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        ItemSelectable cb = evt.getItemSelectable();
        if (cb == this.choice) {
            int ch = new Integer(this.choice.getSelectedItem());
            this.setSpeed(ch);
            this.start();
        }
        if (cb == this.x) {
            this.setAxis(0, 0, 1);
        }
        if (cb == this.y) {
            this.setAxis(0, 1, 0);
        }
        if (cb == this.z) {
            this.setAxis(1, 0, 0);
        }
    }
}

