/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky3d;

import hipparcos.sky3d.Sky3D;
import hipparcos.sky3d.Star3D;
import hipparcos.tools.Browser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.vecmath.Vector3d;

public class StarPanel
extends Panel
implements ActionListener {
    protected Star3D star;
    Label hip;
    Label pos;
    Label alpha;
    Label delta;
    Label paralax;
    Label dist;
    Label mag;
    Label b_v;
    Label status;

    protected void init() {
        this.hip = new Label("Select", 2);
        this.pos = new Label("a star ", 2);
        this.alpha = new Label("  by", 2);
        this.delta = new Label("clicking", 2);
        this.paralax = new Label("on it. ", 2);
        this.dist = new Label("     ", 2);
        this.mag = new Label("     ", 2);
        this.b_v = new Label("     ", 2);
        Label hipl = new Label("HIP:");
        hipl.setForeground(Color.blue);
        Label posl = new Label("Pos:");
        posl.setForeground(Color.blue);
        Label alphal = new Label("alpha:");
        alphal.setForeground(Color.blue);
        Label deltal = new Label("delta:");
        deltal.setForeground(Color.blue);
        Label paralaxl = new Label("parallax(mas):");
        paralaxl.setForeground(Color.blue);
        Label distl = new Label("dist(pc):");
        distl.setForeground(Color.blue);
        Label magl = new Label("V(mag):");
        magl.setForeground(Color.blue);
        Label b_vl = new Label("B-V(mag):");
        b_vl.setForeground(Color.blue);
        this.setLayout(new BorderLayout(0, 0));
        Label title = new Label("Last Star Selected", 1);
        title.setForeground(Color.blue);
        this.add("North", title);
        Button view = new Button("View details");
        view.addActionListener(this);
        this.add("South", view);
        Panel data = new Panel();
        data.setLayout(new GridLayout(8, 2, 0, 0));
        data.add(hipl);
        data.add(this.hip);
        data.add(posl);
        data.add(this.pos);
        data.add(alphal);
        data.add(this.alpha);
        data.add(deltal);
        data.add(this.delta);
        data.add(paralaxl);
        data.add(this.paralax);
        data.add(distl);
        data.add(this.dist);
        data.add(magl);
        data.add(this.mag);
        data.add(b_vl);
        data.add(this.b_v);
        this.add("Center", data);
        this.setBackground(Color.white);
    }

    public void setStatus(Label status) {
        this.status = status;
    }

    public void setStar(Star3D star) {
        this.star = star;
        this.refresh();
    }

    protected void refresh() {
        if (this.star != null) {
            this.hip.setText(this.star.getStar().getId());
            float dis = (float)(1000.0 / this.star.getStar().getParalax());
            Vector3d p = Sky3D.makeVec(this.star.getStar());
            this.pos.setText("" + (int)p.x + "," + (int)p.y + "," + (int)p.z);
            this.alpha.setText("" + this.star.getStar().getAlpha());
            this.delta.setText("" + this.star.getStar().getDelta());
            this.mag.setText("" + this.star.getStar().getMag());
            this.b_v.setText("" + this.star.getStar().getB_V());
            this.paralax.setText("" + this.star.getStar().getParalax());
            this.dist.setText("" + dis);
        }
    }

    public StarPanel() {
        this.init();
    }

    public Star3D getStar() {
        return this.star;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == "View details") {
            String res = Browser.goTo(this.star.getStar().makeUrl());
            if (this.status != null) {
                this.status.setText(res);
            }
        }
    }
}

