/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky3d;

import hipparcos.sky.StarList;
import hipparcos.sky3d.ColourPanel;
import hipparcos.sky3d.RotatePanel;
import hipparcos.sky3d.Sky3D;
import hipparcos.sky3d.StarPanel;
import hipparcos.tools.Constants;
import hipparcos.tools.NoMoreStars;
import hipparcos.tools.Star;
import hipparcos.tools.StarFactory3d;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.vecmath.Vector3d;

public class StarView
extends Frame
implements ActionListener {
    private Sky3D theSky;
    private Label info1;
    private TextField raField;
    private TextField decField;
    private TextField distField;
    private TextField radiusField;
    private TextField threshField;
    protected StarPanel starPanel;
    protected RotatePanel rotPanel;
    protected StarList lister;
    private double step = 0.1;

    public static void main(String[] argv) {
        StarView ap = new StarView();
        ap.pack();
        ap.init();
        ap.show();
    }

    public StarView() {
        super("Hipparcos 3D");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(750, 680);
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.info1 = new Label("Welcome !");
        this.add("North", this.info1);
        this.theSky = new Sky3D();
        this.add("Center", (Component)((Object)this.theSky));
        FlowLayout fl = new FlowLayout(1, 1, 1);
        Panel p = new Panel(fl);
        Label raLabel = new Label("Alpha:");
        this.raField = new TextField(8);
        this.raField.setText("65.5");
        p.add(raLabel);
        p.add(this.raField);
        Label decLabel = new Label("Delta:");
        this.decField = new TextField(8);
        this.decField.setText("15.5");
        p.add(decLabel);
        p.add(this.decField);
        Label dLabel = new Label("dist(pc):");
        this.distField = new TextField(5);
        this.distField.setText("40");
        p.add(dLabel);
        p.add(this.distField);
        Label lparLabel = new Label("radius(pc):");
        this.radiusField = new TextField("10", 4);
        p.add(lparLabel);
        p.add(this.radiusField);
        Label threshLabel = new Label("V(lim):");
        this.threshField = new TextField("99", 3);
        p.add(threshLabel);
        p.add(this.threshField);
        Button fetch = new Button("View");
        fetch.addActionListener(this);
        p.add("West", fetch);
        Button quit = new Button("Quit");
        quit.addActionListener(this);
        p.add("West", quit);
        Button list = new Button("List");
        list.addActionListener(this);
        p.add("East", list);
        this.add("South", p);
        Panel rp = new Panel();
        rp.setBackground(Color.black);
        GridBagLayout gridbag = new GridBagLayout();
        rp.setLayout(gridbag);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridy = -1;
        cons.gridx = 0;
        cons.ipadx = 0;
        cons.ipady = 10;
        this.starPanel = new StarPanel();
        gridbag.setConstraints(this.starPanel, cons);
        rp.add(this.starPanel);
        this.theSky.setStarPanel(this.starPanel);
        this.starPanel.setStatus(this.info1);
        ColourPanel cp = new ColourPanel();
        gridbag.setConstraints(cp, cons);
        rp.add(cp);
        this.rotPanel = new RotatePanel();
        gridbag.setConstraints(this.rotPanel, cons);
        rp.add(this.rotPanel);
        this.rotPanel.setScene(this.theSky);
        this.add("East", rp);
        this.lister = new StarList(this.theSky);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == "List") {
            this.lister.setVisible(true);
            this.lister.refresh();
        }
        if (label == "Quit") {
            System.exit(0);
        }
        if (label == "View") {
            float ra = 65.5f;
            float dec = 15.5f;
            float d = 40.0f;
            float rad = 10.0f;
            float vlim = 99.0f;
            try {
                ra = new Float(this.raField.getText().trim()).floatValue();
                dec = new Float(this.decField.getText().trim()).floatValue();
                d = new Float(this.distField.getText().trim()).intValue();
                rad = new Float(this.radiusField.getText().trim()).intValue();
                vlim = new Float(this.threshField.getText().trim()).intValue();
            }
            catch (Exception exp) {
                System.err.println(" Parameter error " + exp);
            }
            this.info1.setText("Fetching Data " + ra + " " + dec + " " + d + " " + rad + " V(lim):" + vlim);
            this.theSky.setupScene(ra, dec, d, rad);
            this.populate(ra, dec, d, rad, vlim);
            this.theSky.showScene();
            this.rotPanel.setFactor((int)rad);
            this.rotPanel.stop();
            this.info1.setText("Center is " + this.theSky.center());
            return;
        }
    }

    private void populate(double ra, double dec, double d, double rad, double vlim) {
        Vector3d vec = Sky3D.makeVecParsec(ra, dec, d);
        StarFactory3d fac = new StarFactory3d(vec.x, vec.y, vec.z, rad, vlim);
        boolean more = true;
        while (more) {
            try {
                Star star = fac.getNext();
                this.theSky.addStar(star);
            }
            catch (NoMoreStars nms) {
                if (Constants.verbose > 2) {
                    System.out.println("No more stars");
                }
                more = false;
            }
        }
    }
}

