/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.tools;

import hipparcos.tools.Constants;
import hipparcos.tools.HIPproperties;
import java.applet.AppletContext;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class Browser {
    protected static AppletContext apCon = null;
    protected static boolean mainFrame = false;

    public static void setMainFrame() {
        mainFrame = true;
    }

    public static void setAppletContext(AppletContext apCon) {
        Browser.apCon = apCon;
    }

    public static boolean inApplet() {
        return apCon != null && !mainFrame;
    }

    public static String goTo(String location) {
        String cmd = null;
        try {
            String theBrowser = HIPproperties.getProperty("browser");
            if (theBrowser == null) {
                Browser.gotToDesktop(location);
            }
            cmd = theBrowser + " -raise -remote openURL(" + location + ")";
            if (Constants.verbose > 1) {
                System.out.print("Running " + cmd);
            }
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            p.waitFor();
            if (Constants.verbose > 1) {
                System.out.println(".. exit " + p.exitValue());
            }
            if (p.exitValue() != 0) {
                cmd = theBrowser + " " + location;
                if (Constants.verbose > 1) {
                    System.out.println("Trying " + cmd + " instead. ");
                }
                p = rt.exec(cmd);
            }
        }
        catch (Exception e) {
            String err = "Could not run browser " + cmd + " check the browser property - leave it empty for default behaviour.";
            System.err.println(err + ":" + e);
            return err;
        }
        return cmd;
    }

    public static void gotToDesktop(String location) throws IOException, URISyntaxException {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(new URI(location));
        }
    }

    public static String goTo(URL location) {
        if (Browser.inApplet()) {
            apCon.showDocument(location, "The Hipparcos Catalogue");
            return "Browser :" + location;
        }
        return Browser.goTo(location.toString());
    }
}

