/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.tools;

import hipparcos.tools.Constants;
import hipparcos.tools.HIPproperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public abstract class Factory {
    protected BufferedReader dstream = null;
    protected static boolean disk = HIPproperties.getProperty("datasource", "www").startsWith("disk");
    String catprog;
    String wwwid;

    public Factory(int id, String catprog, String wwwid) {
        this.catprog = catprog;
        this.wwwid = wwwid;
        if (disk) {
            this.loadFromDisk(id);
        } else {
            this.loadFromURL(id);
            this.skipToData();
        }
    }

    public Factory() {
    }

    protected void skipToData() {
        String str = null;
        try {
            boolean found = false;
            while (!found) {
                str = this.dstream.readLine();
                if (Constants.verbose > 5) {
                    System.out.println("Skip :" + str);
                }
                found = str == null || str.startsWith("<pre") || str.startsWith("<PRE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean loadFromURL(int id) {
        String theUrl = HIPproperties.getProperty("hipurl");
        if (Constants.verbose > 2) {
            System.out.println("Got property hipurl" + theUrl + ".");
        }
        theUrl = theUrl + "?noLinks=1&tabular=1&";
        theUrl = theUrl + this.wwwid + "=" + new Integer(id).toString();
        return this.openURL(theUrl);
    }

    public boolean loadFromDisk(int id) {
        String bins = HIPproperties.getProperty("bins");
        String cmd = bins + "/" + this.catprog + " -ts ";
        cmd = cmd + new Integer(id).toString() + " ";
        return this.openDisk(cmd);
    }

    protected boolean openURL(String theUrl) {
        try {
            URL url = new URL(theUrl);
            InputStreamReader istream = new InputStreamReader(url.openStream());
            this.dstream = new BufferedReader(istream);
            if (Constants.verbose > 1) {
                System.out.println("opened " + theUrl + ".");
            }
        }
        catch (Exception e) {
            System.err.println("loadFromURL HIPEP: " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean openDisk(String cmd) {
        try {
            if (Constants.verbose > 1) {
                System.out.println("Running " + cmd + ".");
            }
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            InputStreamReader istream = new InputStreamReader(p.getInputStream());
            this.dstream = new BufferedReader(istream);
            return true;
        }
        catch (Exception e) {
            System.err.println("Some problem with " + cmd);
            e.printStackTrace();
            return false;
        }
    }

    public abstract Object getObj() throws Exception;
}

