/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.tools;

import hipparcos.tools.Browser;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;

public class HIPproperties {
    static Properties props = null;

    static void init() {
        props = new Properties();
        if (Browser.inApplet()) {
            props.put("hipurl", "https://hipparcos-tools.cosmos.esa.int/cgi-bin/HIPcatalogueSearch.pl");
        } else {
            String toolProps = System.getProperty("toolProps", "hipparcos.properties");
            try {
                String fn = HIPproperties.locateFile(toolProps);
                FileInputStream in = new FileInputStream(fn);
                props.load(in);
                in.close();
            }
            catch (Exception e) {
                File dir = new File(".");
                String curDir = dir.getAbsolutePath();
                System.err.println(" Can not find " + toolProps + " use -DtoolProps=path to specify location if not in current dir (" + curDir + ")");
                props.put("hipurl", "https://hipparcos-tools.cosmos.esa.int/cgi-bin/HIPcatalogueSearch.pl");
            }
        }
    }

    public static String getProperty(String prop) {
        if (props == null) {
            HIPproperties.init();
        }
        return props.getProperty(prop);
    }

    public static String getProperty(String prop, String def) {
        if (props == null) {
            HIPproperties.init();
        }
        return props.getProperty(prop, def);
    }

    public static String locateFile(String filename) throws Exception {
        String shortFileName = filename;
        File absFile = new File(filename);
        if (absFile.isAbsolute()) {
            if (absFile.exists()) {
                return filename;
            }
            shortFileName = absFile.getName();
        }
        String[] propDirs = new String[]{".", "conf"};
        String EXTENSION = ".properties";
        ArrayList<File> fileNameList = new ArrayList<File>(propDirs.length);
        for (String dir : propDirs) {
            File f = new File(dir, shortFileName);
            if (!f.exists()) continue;
            fileNameList.add(f);
        }
        if (filename.trim().endsWith(EXTENSION) && fileNameList.size() > 1) {
            throw new Exception("Property file: " + shortFileName + " found in " + fileNameList.size() + " locations.");
        }
        if (!fileNameList.isEmpty()) {
            return ((File)fileNameList.get(0)).getAbsolutePath();
        }
        return null;
    }
}

