/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.tools;

import hipparcos.tools.Constants;
import hipparcos.tools.HIPproperties;
import hipparcos.tools.NoMoreStars;
import hipparcos.tools.Star;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class StarFactory {
    protected boolean hipOnly = false;
    protected double alpha = 0.0;
    protected double delta = 0.0;
    protected double vlim = 99.0;
    protected double d = 0.0;
    protected BufferedReader dstream = null;
    protected boolean finished = false;
    protected boolean hipDone = false;
    protected boolean opened = false;
    protected boolean disk = false;
    protected String[] catprogs = new String[]{"shipmainra", "stycmainra"};

    protected StarFactory(double vlim, boolean hipOnly) {
        this.vlim = vlim;
        this.hipOnly = hipOnly;
    }

    public StarFactory(double alpha, double delta, double d) {
        this.alpha = alpha;
        this.delta = delta;
        this.d = d;
        this.finished = !this.openStream();
    }

    public StarFactory(double alpha, double delta, double d, double vlim, boolean hipOnly) {
        this.hipOnly = hipOnly;
        this.alpha = alpha;
        this.delta = delta;
        this.d = d;
        this.vlim = vlim;
        this.finished = !this.openStream();
    }

    protected boolean openStream() {
        this.opened = true;
        this.finished = false;
        this.disk = HIPproperties.getProperty("datasource", "www").startsWith("disk");
        if (this.disk) {
            return this.loadFromDisk(this.catprogs[0]);
        }
        if (this.loadFromURL()) {
            try {
                this.skipToData();
                return true;
            }
            catch (Exception e) {
                System.err.println("openStream: could not skip to data " + e);
                e.printStackTrace();
            }
        }
        this.finished = true;
        return false;
    }

    protected boolean loadFromDisk(String catprog) {
        try {
            String bins = HIPproperties.getProperty("bins");
            String cmd = bins + "/" + catprog + " -tq ";
            cmd = cmd + new Double(this.alpha).toString() + " ";
            cmd = cmd + new Double(this.delta).toString() + " ";
            cmd = cmd + new Double(this.d).toString();
            if (Constants.verbose > 1) {
                System.out.println("Running " + cmd + ".");
            }
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            InputStreamReader istream = new InputStreamReader(p.getInputStream());
            this.dstream = new BufferedReader(istream);
            return true;
        }
        catch (Exception e) {
            System.err.println("Some problem starting cat progs");
            e.printStackTrace();
            return false;
        }
    }

    protected boolean loadFromURL() {
        try {
            String theUrl = HIPproperties.getProperty("hipurl");
            if (Constants.verbose > 2) {
                System.out.println("Got property hipurl" + theUrl + ".");
            }
            theUrl = theUrl + "?noLinks=1&raDecim=";
            theUrl = theUrl + new Double(this.alpha).toString();
            theUrl = theUrl + "&decDecim=";
            theUrl = theUrl + new Double(this.delta).toString();
            theUrl = theUrl + "&box=";
            theUrl = theUrl + new Double(this.d).toString();
            URL url = new URL(theUrl);
            InputStreamReader istream = new InputStreamReader(url.openStream());
            this.dstream = new BufferedReader(istream);
            if (Constants.verbose > 1) {
                System.out.println("opened " + theUrl + ".");
            }
        }
        catch (Exception e) {
            System.err.println("loadFromURL: " + e);
            return false;
        }
        return true;
    }

    protected void skipToData() throws Exception {
        String str;
        if (Constants.verbose > 3) {
            System.out.println("Skipping to data ..");
        }
        boolean found = false;
        while (!found) {
            str = this.dstream.readLine();
            found = str == null || str.startsWith("<pre>") || str.startsWith("<PRE>");
        }
        str = this.dstream.readLine();
    }

    public Star getNext() throws NoMoreStars {
        if (!this.opened) {
            this.openStream();
        }
        if (this.finished) {
            throw new NoMoreStars();
        }
        boolean found = false;
        Star star = null;
        while (!found) {
            String str;
            block21: {
                str = null;
                try {
                    str = this.dstream.readLine();
                    if (Constants.verbose > 5) {
                        System.out.println(str);
                    }
                }
                catch (Exception e) {
                    if (Constants.verbose <= 5) break block21;
                    e.printStackTrace();
                }
            }
            if (str == null) {
                if (this.disk && this.catprogs[1] != null && !this.hipDone && !this.hipOnly) {
                    this.loadFromDisk(this.catprogs[1]);
                    this.hipDone = true;
                    try {
                        str = this.dstream.readLine();
                    }
                    catch (Exception tyce) {
                        tyce.printStackTrace();
                        throw new NoMoreStars();
                    }
                }
                this.finished = true;
                try {
                    this.dstream.close();
                }
                catch (Exception tyce) {
                    // empty catch block
                }
                throw new NoMoreStars();
            }
            if (str.startsWith("</pre>") || str.startsWith("</PRE>")) {
                if (this.hipDone || this.hipOnly) {
                    this.finished = true;
                    try {
                        this.dstream.close();
                    }
                    catch (Exception tyce) {
                        // empty catch block
                    }
                    throw new NoMoreStars();
                }
                try {
                    this.skipToData();
                    str = this.dstream.readLine();
                }
                catch (Exception e) {
                    System.err.println("StarFactory:header " + e);
                    throw new NoMoreStars();
                }
                this.hipDone = true;
            }
            try {
                star = new Star(str);
                found = true;
            }
            catch (Exception e) {
                if (Constants.verbose <= 3) continue;
                System.err.println("getNext: Unusable Star " + e);
            }
        }
        if (Constants.verbose > 3) {
            System.out.println("got: " + star);
        }
        return star;
    }
}

