% DiodeConn.m
% BJT diode connected transistor Vce vs. Ie data and curve fit.
% 
% Current values are in mA.
%
% Figure 2 graph shows how to specify italic and subscript text in labels
%
IeMeas=[0.25 0.5 0.75 1 1.25 1.5 1.75 2]; %Measured Ie
VceMeas=[0.604 0.621 0.632 0.639 0.645 0.649 0.653 0.656 ];  %Measured Vce
Ie=polyfit(IeMeas,VceMeas,4);  % 4th-order polynomial fit

IeRange=[0.25:0.002:2];    % Ie range in mA
 
VceFit=polyval(Ie,IeRange);  % Make smooth curve over measured Ie range

% dIe is derivative of Ie polynomial found manually from Ie coefficients
dIe=[-2.81e-2 0.1275 -0.2 0.126];  % Derivative of Ie polynomial found, 4 terms

% Ro is output resistance curve from 4th order polynomial fit
Ro=polyval(dIe,IeRange)*1000;  

figure(1)
plot(IeMeas,VceMeas,'*',IeRange,VceFit)
axis([0.25 2 0.5 0.7])
title('V_{CE} vs. I_{E}')
xlabel('I_{E}, mA')
ylabel('V_{CE}, V')
grid

figure(2)   % Use separate figure
plot(IeRange,Ro)
title('Output Resistance vs. Emitter Current')
xlabel('\itI\rm_{E}, mA')
ylabel('\itR\rm_{o}, \Omega')
grid
