% Diodecurv.m
% Diode exponential curve matching and plotting
%
% Plots measured data and exponential curve fit to measured data
% 
% 
clear
idmeas=[0 0 0 0 0 0 0 0 0]; %Measured id values in amps for testing fit
vdmeas=[0 0 0 0 0 0 0 0 0];  %Measured vd values for testing fit

% Create the exponential fit to measured data
f=fit(vdmeas',idmeas','exp1','TolFun',1e-10);  %Tighter tolerance than default

vd1=[0:0.005:0.7];  %Create voltage point array for matched function values
id1=f(vd1);  %Calculate matched function values


% The current values are plotted in mA by scaling x1000
plot(vdmeas,idmeas*1000,'o',vd1,id1*1000)
title('Diode Forward Characteristic')
xlabel('V_{D}, V')
ylabel('I_{D}, mA')
grid
