% MOSFET Parabola Matching
%
% The parabola match will be best if you include only one or two points
% with current less than 1 mA.
% Current values are in mA. 
% Replace the zeros with your data. You may have a different number of
% points than the number of zeros.
%
idmeas=[0 0 0 0 0]; %All measured id values in mA
vgsmeas=[0 0 0 0 0]; %All measured vgs values
idfit=[0 0 0 0];   %Measured id values used for curve fit
vgsfit=[0 0 0 0];  %Measured vgs values used for curve fit
p=polyfit(vgsfit,idfit,2);  %Find 2nd order polynomial coefficients
vgs1=[0:0.02:3.5];  %vgs range for parabola calculation, increment=0.02V
id1=polyval(p,vgs1);
plot(vgsmeas,idmeas,'*',vgs1,id1)  %Points only for meas, line for calc
axis([1 3.5 0 120])  %Typical axis settings, you can change
xlabel('Vgs, V')
ylabel('Id, mA')
grid
