/**
 * A simple demo of Processing, which displays a rectangle.
 * The rectangle disappears with a mouse click and reappears with
 * a click to any key on keyboard.
 */
boolean visible = true;

void setup() {
  size(400, 400); // Set the canvas size to 400x400 pixels
}

void draw() {
  // This function is continuously called in a loop
  // It allows you to draw and update elements on the canvas
  background(255);  //comment out this line to see what happens
  if (visible) {
     fill(0, 255, 0); // Set the fill color to green (R: 0, G: 255, B: 0)
     rect(150, 150, 100, 50); // Draw a green rectangle at position (150, 150) with width 100 and height 50
  }
}

void mousePressed() {
  // This function is called whenever the mouse is pressed
  // You can add code here to respond to mouse clicks
  visible = false; // Set the fill color to red (R: 255, G: 0, B: 0)
}

void keyPressed() {
  // This function is called whenever a key is pressed
  // You can add code here to respond to key presses
  visible = true;
}
