PImage mapImage;
Table locationTable;
int rowCount;
Table dataTable;
float dataMin = MAX_FLOAT;
float dataMax = MIN_FLOAT;

void setup(  ) {
  size(640, 400);
  mapImage = loadImage("map.png");
  locationTable = loadTable("locations.tsv");
  rowCount = locationTable.getRowCount(  );

// Read the data table.
  dataTable = loadTable("random.tsv");

  // Find the minimum and maximum values.
  for (int row = 0; row < rowCount; row++) {
    float value = dataTable.getFloat(row, 1);
    if (value > dataMax) {
      dataMax = value;
    }
    if (value < dataMin) {
      dataMin = value;
    }
  }
}

void draw(  ) {
  background(255);
  image(mapImage, 0, 0);

  smooth(  );
  fill(192, 0, 0);
  noStroke(  );
  for (int row = 0; row < rowCount; row++) {
    float x = locationTable.getFloat(row, 1);
    float y = locationTable.getFloat(row, 2);
    drawData(x, y, row);
  }
}

// Map the size of the ellipse to the data value
void drawData(float x, float y, int row) {
  // Get data value for state
  float value = dataTable.getFloat(row, 1);
  // Re-map the value to a number between 2 and 40
  float mapped = map(value, dataMin, dataMax, 2, 40);
  // Draw an ellipse for this item
  ellipse(x, y, mapped, mapped);
}
