int numCircles = 200;
int[] circleX = new int[numCircles];
int[] circleY = new int[numCircles];
int[] circleSize = new int[numCircles];
color[] circleColor = new color[numCircles];

void setup() {
  size(400, 400);
  smooth();
  noStroke();
  for (int i = 0; i < numCircles; i++) {
    float t = random(0, TWO_PI);
    float r = random(0, 50);
    float x = r * cos(t) + width / 2;
    float y = r * sin(t) + height / 2 + 50;
    circleX[i] = int(x);
    circleY[i] = int(y);
    circleSize[i] = int(random(3, 7));
    circleColor[i] = color(random(255), random(255), random(255), 200);
  }
}

void draw() {
  background(255);
  noStroke();
  for (int i = 0; i < numCircles; i++) {
    circleY[i] += int(random(1, 3)); //add a small random number to y (i.e. going down a little)
    if (circleY[i] > height - 20) {  //if reach bottom, reset the y to a negative value (i.e. out of view above the top of the window)
      circleY[i] = int(random(-50, -10));
    }
    fill(circleColor[i]);
    ellipse(circleX[i], circleY[i], circleSize[i], circleSize[i]);
  }
  
  fill(255, 170, 0);
  stroke(255, 170, 0);
  strokeWeight(2);
  
  beginShape();
  vertex(80, height - 20);
  vertex(320, height - 20);
  vertex(310, height - 10);
  vertex(90, height - 10);
  endShape(CLOSE);
  
  //noLoop();
}
