int numCircles = 200;
int[] circleX = new int[numCircles];
int[] circleY = new int[numCircles];
int[] circleSize = new int[numCircles];
color[] circleColor = new color[numCircles];

void setup() {
  size(400, 400);
  smooth();
  noStroke();
  for (int i = 0; i < numCircles; i++) {
    float t = random(0, TWO_PI);
    float r = random(0, 100);
    float x = r * cos(t) + width / 2;
    float y = r * sin(t) + height / 2 + 50;
    circleX[i] = int(x);
    circleY[i] = int(y);
    circleSize[i] = int(random(3, 7));
    circleColor[i] = color(random(255), random(255), random(255), 200);
  }
}

void draw() {
  background(255);
  fill(255, 170, 0);
  stroke(255, 170, 0);
  strokeWeight(2);
  beginShape();
  vertex(80, height - 20);
  vertex(320, height - 20);
  vertex(310, height - 10);
  vertex(90, height - 10);
  endShape(CLOSE);
  noStroke();
  for (int i = 0; i < numCircles; i++) {
    circleY[i] += int(random(1, 3));
    if (circleY[i] > height - 20) {
      circleY[i] = int(random(-50, -10));
    }
    fill(circleColor[i]);
    ellipse(circleX[i], circleY[i], circleSize[i], circleSize[i]);
  }
}
