int num = 10;  //# of birds
float[] x = new float[num];   //x coordinates
float[] y = new float[num];   //y coordinates
float[] speedX = new float[num]; //speeds along x axis
float[] speedY = new float[num]; //speeds along y axis
float[] wingSpan = new float[num]; //Widths of the bird's wings 
float[] wingPosition = new float[num]; //Position of the wings (to simulate flapping)

void setup() {
  size(800, 600);
  for (int i = 0; i < num; i++) {
    x[i] = random(width/2); 
    y[i] = random(height);
    wingSpan[i] = 30; // Initial wing position
    speedX[i] = 2; // Constant horizontal speed
    speedY[i] = 0; // No vertical speed
    wingPosition[i] = 0; // Initial wing position
  }
}

void draw() {
  background(135, 206, 250); // Sky blue background
  for (int i=0; i < num; i++) {
    update(i);
    display(i);
  }
}


void update(int i) {
  x[i] += speedX[i];
  y[i] += speedY[i];
  
  // Check for collision with the screen boundaries
  if (x[i] <= 0 || x[i] >= width) {
    speedX[i] *= -1;
  }
  if (y[i] <= 0 || y[i] >= height) {
    speedY[i] *= -1;
  }

  // Simulate wing flapping
  wingPosition[i] = sin(radians(frameCount * 5)) * 20; // Flap the wings up and down
}

void display(int i) {
  fill(255, 200, 0); // Yellow color
  ellipse(x[i], y[i], 30, 20);

  // Draw wings
  fill(255); // White color
  pushMatrix();
  translate(x[i], y[i]);
  rotate(radians(wingPosition[i]));
  triangle(0, 0, -wingSpan[i] / 2, 15, -wingSpan[i] / 2, -15);
  triangle(0, 0, wingSpan[i] / 2, 15, wingSpan[i] / 2, -15);
  popMatrix();
}
