// Bird class to represent a flying bird
class Bird {
  float x, y; // Position of the bird
  float speedX, speedY; // Speed of the bird
  float wingSpan; // Width of the bird's wings
  float wingPosition; // Position of the wings (to simulate flapping)

  Bird(float x, float y, float wingSpan) {
    this.x = x;
    this.y = y;
    this.wingSpan = wingSpan;
    this.speedX = 2; // Constant horizontal speed
    this.speedY = 0; // The bird starts without vertical speed
    this.wingPosition = 0; // Initial wing position
  }

  // Update the bird's position and wing flapping
  void update() {
    x += speedX;
    y += speedY;
    
    // Check for collision with the screen boundaries
    if (x <= 0 || x >= width) {
      speedX *= -1;
    }
    if (y <= 0 || y >= height) {
      speedY *= -1;
    }
    // Simulate wing flapping
    wingPosition = sin(radians(frameCount * 5)) * 20; // Flap the wings up and down
  }

  // Display the bird
  void display() {
    // Draw body
    fill(255, 200, 0); // Yellow color
    ellipse(x, y, 30, 20);

    // Draw wings
    fill(255); // White color
    pushMatrix();
    translate(x, y);
    rotate(radians(wingPosition));
    triangle(0, 0, -wingSpan / 2, 15, -wingSpan / 2, -15);
    triangle(0, 0, wingSpan / 2, 15, wingSpan / 2, -15);
    popMatrix();
  }
}
