// Arrays to store attributes of multiple balls
int num = 5;  //# of balls
float[] x = new float[num];   //x coordinates
float[] y = new float[num];   //y coordinates
float[] speedX = new float[num]; //speeds along x axis
float[] speedY = new float[num]; //speeds along y axis
float[] diameter = new float[num]; //diameters 

/**
 * setup method -  called once at the start of the program 
 * 
 * Initialize the attributes of balls
 */
void setup() {
  size(800, 600);  //window size
  for (int i = 0; i < num; i++) { 
    x[i] = random(width);         //set to a random value in [0, width)
    y[i] = random(height);        //set to a random value in [0, height)
    diameter[i] = random(20, 50); //set to a random value in [20, 50)
    speedX[i] = random(1, 3);     //set to a random value in [1, 3)
    speedY[i] = random(1, 3);     //set to a random value in [1, 3)
  }
}

/**
 * draw method - by default, called 60 times per second.
 *
 * Move and display each ball
 */
void draw() {
  background(255);
  for (int i = 0; i < num; i++) {
    move(i);
    display(i);
  }
}


/**
 * Move the ball with index i
 */
void move(int i) {
  x[i] += speedX[i];  //x coordinated modified by speed along x axis
  y[i] += speedY[i];  //y coordinated modified by speed along y axis

  // Check for collision with the screen boundaries
  if (x[i] <= 0 || x[i] >= width) {  //if goes to out of the window along x axis
    speedX[i] *= -1;  //reverse speed direction along x axis
  }
  if (y[i] <= 0 || y[i] >= height) { //if goes to out of the window along y axis
    speedY[i] *= -1;  //reverse speed direction along y axis
  }
}

/**
 * Display the ball with index i
 */
void display(int i) {
  ellipse(x[i], y[i], diameter[i], diameter[i]); //draw a circle
}
 
