// Ball class to represent a moving ball
class Ball {
  float x, y;           // Position of the ball
  float speedX, speedY; // Speed of the ball
  float diameter;       // Diameter of the ball

  //Constructor method that create a ball with the 
  //specified position and diameter
  Ball(float x, float y, float diameter) {
    this.x = x;
    this.y = y;
    this.diameter = diameter;
    this.speedX = random(1, 3); // initial X speed set to a random value in [1, 3)
    this.speedY = random(1, 3); // initial Y speed set to a random value in [1, 3)
  }

  // Move the ball
  void move() {
    x += speedX;
    y += speedY;

    // Check for collision with the screen boundaries
    if (x <= 0 || x >= width) {
      speedX *= -1;
    }
    if (y <= 0 || y >= height) {
      speedY *= -1;
    }
  }

  // Display the ball
  void display() {
    ellipse(x, y, diameter, diameter);
  }
}
