# ce00 Review Exercise

![Approved for: Fall 2020](https://img.shields.io/badge/Approved%20for-Fall%202020-blueviolet)

This exercise is designed to review some of the object-oriented concepts from your introductory programming course.
If you have trouble implementing any of the methods or understanding any concepts in this exercise, your instructors
recommend thoroughly reviewing your introductory course materials and asking questions to fill in any gaps. 
**All concepts in this exercise will be critical moving forward in CSCI 1302.**

## Prerequisite Knowledge

* [CSCI 1302 Reference Variable Refresher](https://github.com/cs1302uga/cs1302-tutorials/blob/master/refresher/variables.md)
* A strong understanding of Arrays, Classes and Ojects in the Java programming language.

## Getting Started

   1. Read the following disclaimers:
      
      > In CSCI 1302, per the syllabus, all of your course-related programing will take place in a 
      > Unix-like environment on the department's Nike server. This includes editing source code
      > using a terminal-based text editor such as Emacs or Vi (i.e., no Eclipse, IntelliJ, BlueJ, etc.), 
      > compiling source code from the terminal, generating user-facing documentation, and 
      > even program execution.
      
      > **The only exception to the previous disclaimer is today's exercise!** You've already taken
      > at least one semester of programming, so use the tools you're currently familiar with to
      > complete this exercise.
      
   1. In your IDE of choice, create a project called `cs1302-ce00`. 
   1. Download [Money.java](https://raw.githubusercontent.com/cs1302uga/cs1302-ce00/master/src/Money.java)
   1. Download [Wallet.java](https://raw.githubusercontent.com/cs1302uga/cs1302-ce00/master/src/Wallet.java)
   1. Download [WalletDriver.java](https://raw.githubusercontent.com/cs1302uga/cs1302-ce00/master/src/WalletDriver.java)
   1. Place `Money.java`, `Wallet.java` and `WalletDriver.java` in the `src` folder of your `cs1302-ce00` project folder.

## Introductory Video

1. You might find the following introductory video helpful for getting started with the exercise:

   https://youtu.be/puduQZisWsc

   <a href="https://www.youtube.com/watch?v=puduQZisWsc">
   <img src="https://i3.ytimg.com/vi/puduQZisWsc/hqdefault.jpg" alt="IMAGE ALT TEXT">
   </a>
   
## Exercise Steps

   1. Navigate to [API Documentation](http://cobweb.cs.uga.edu/~cs1302a/cs1302-ce00-doc/).
   1. The `Money.java` class is fully implemented for you. Read through the API documentation on the
      API documentation website to understand the methods that are available and how to use them.
   1. Your main job for this exercise is to implement `Wallet.java`. There are four unimplemented methods. 
      However, the signatures are provided for you. The comments in the API documentation contain detailed 
      guidelines that you should follow for implementation. **You should read all of the comments before
      writing any code.**
   1. Once you have implemented the methods, execute the `WalletDriver.java` class which contains 
      a series of unit tests to thoroughly test your implementation. If you do not pass a test, then
      inspect the test to see what it's doing, then try to fix your code.
   
<hr/>

[![License: CC BY-NC-ND 4.0](https://img.shields.io/badge/License-CC%20BY--NC--ND%204.0-lightgrey.svg)](http://creativecommons.org/licenses/by-nc-nd/4.0/) [![License: CC BY-NC 4.0](https://img.shields.io/badge/Instructor%20License-CC%20BY--NC%204.0-lightgrey.svg)](http://creativecommons.org/licenses/by-nc/4.0/)

<small>
Copyright &copy; Michael E. Cotterell, Bradley J. Barnes, and the University of Georgia.
This work is licensed under 
a <a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a> to students and the public and licensed under
a <a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/">Creative Commons Attribution-NonCommercial 4.0 International License</a> to instructors at institutions of higher education.
The content and opinions expressed on this Web page do not necessarily reflect the views of nor are they endorsed by the University of Georgia or the University System of Georgia.
</small>
