# Generic Classes Tutorial

![Approved for: Fall 2020](https://img.shields.io/badge/Approved%20for-Fall%202020-blueviolet)

This tutorial introduces the reader to generic classes in Java by creating a new generic class
and emphasizing some of the benefits of using generics.

### Prerequisites

This tutorial assumes that the reader has a knowledge of basic Unix commands and experience working
with a command-line text editor (e.g. emacs, vi, etc.). The reader should be familiar with compiling
and running Java code contained in packages.

To get the most out of this tutorial, you should follow along and take notes.

### Course-Specific Learning Outcomes

* **LO2.d:** (Partial) Implement new generic methods, interfaces, and classes in a software solution.

### Getting Started

The steps in this tutorial assume that you are logged into the Odin server.

1. Use the following command to download and execute a shell script that retrieves
   the starter code for this tutorial and places it into a subdirectory
   called `cs1302-generic-classes`:

   ```
   $ curl -s -L https://git.io/Je3Dh | bash
   ```

1. Change into the `cs1302-generic-classes` directory that was just created and look around. 
   There should be multiple Java files contained within the directory structure. To see a listing 
   of all of the source code files, use the `find` command as follows:

   ```
   $ find src
   ```

1. Use the starter code to follow along with the video below.

## Video Example

In this video example, we create a generic shipping container class that can hold objects of any type. 
Also, we point out some of the important benefits of generics.

https://youtu.be/m539u1hGP7E

<a href="https://www.youtube.com/watch?v=m539u1hGP7E">
<img src="https://img.youtube.com/vi/m539u1hGP7E/0.jpg?201909191514" alt="Generic Method Example">
</a>

## Required Additional Reading

Now that you're familiar with some of the basic concepts relate to generic
methods in Java, you need to read the official Oracle reading:

* [The Java™ Tutorials: Why Use Generics?](https://docs.oracle.com/javase/tutorial/java/generics/why.html)
* [The Java™ Tutorials: Generic Types](https://docs.oracle.com/javase/tutorial/java/generics/types.html)
* [The Java™ Tutorials: Raw Types](https://docs.oracle.com/javase/tutorial/java/generics/rawTypes.html)

If you have any questions related to the Generic Classes reading provided by
Oracle, then feel free to ask them on the course Piazza.

<hr/>

[![License: CC BY-NC-ND 4.0](https://img.shields.io/badge/License-CC%20BY--NC--ND%204.0-lightgrey.svg)](http://creativecommons.org/licenses/by-nc-nd/4.0/)

<small>
Copyright &copy; Michael E. Cotterell, Bradley J. Barnes, and the University of Georgia.
This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a> to students and the public.
The content and opinions expressed on this Web page do not necessarily reflect the views of nor are they endorsed by the University of Georgia or the University System of Georgia.
</small>
