# CSCI 1302 Class Exercises

## Introduction 

Learning computer science takes much more than pure memorization. Learning how
to think like a computer scientist is a time consuming process, with the key
word being "process". It requires active, engaged participation and questioning
both in and out of class. To aid in this journey, the instructors of this 
course will provide you with many opportunities to learn the material through 
guided readings, active class exercises, and comprehensive project assignments,
however, in the end you will have to do all of the hard work of actually learning 
that material. This is not *self teaching*; instead, it is *guided active learning*.

## Exercise List 

1. [`cs1302-ce00` Review Exercise](https://github.com/cs1302uga/cs1302-ce00)
1. [`cs1302-ce01` Unix Commands](https://github.com/cs1302uga/cs1302-ce01)
1. [`cs1302-ce02` Command Line Compilation and Packages](https://github.com/cs1302uga/cs1302-ce02)
1. [`cs1302-ce03` Multiuser System Fun Times](https://github.com/cs1302uga/cs1302-ce03)
1. [`cs1302-ce04` From Exceptional to Enhanced Cat](https://github.com/cs1302uga/cs1302-ce04)
1. [`cs1302-ce05` API Documentation with Javadoc](https://github.com/cs1302uga/cs1302-ce05)
1. [`cs1302-ce06` Interfaces (ADTs)](https://github.com/cs1302uga/cs1302-ce06)
1. [`cs1302-ce07` Evolving an Interface](https://github.com/cs1302uga/cs1302-ce07)
1. [`cs1302-ce08` A Great Inheritance](https://github.com/cs1302uga/cs1302-ce08)
1. [`cs1302-ce09` More Shapes](https://github.com/cs1302uga/cs1302-ce09)
1. [`cs1302-ce10` Hierarchy Refactoring](https://github.com/cs1302uga/cs1302-ce10)
1. [`cs1302-ce11` Lovable Linked Lists](https://github.com/cs1302uga/cs1302-ce11)
1. [`cs1302-ce12` Subsumption Trade-offs](https://github.com/cs1302uga/cs1302-ce12)
1. [`cs1302-ce13` Java Generics](https://github.com/cs1302uga/cs1302-ce13)
1. [`cs1302-ce14` Genericize is a Real Word](https://github.com/cs1302uga/cs1302-ce14)
1. [`cs1302-ce15` Genericize is Still a Real Word](https://github.com/cs1302uga/cs1302-ce15)
1. [`cs1302-ce16` Gnarly to the Max](https://github.com/cs1302uga/cs1302-ce16)
1. [`cs1302-ce17` Generic Method Implementation](https://github.com/cs1302uga/cs1302-ce17)
1. [`cs1302-ce18` Generic Method Implementation](https://github.com/cs1302uga/cs1302-ce18)
1. [`cs1302-ce19` ImageApp](https://github.com/cs1302uga/cs1302-ce19)
1. [`cs1302-ce20` Fancy ImageApp](https://github.com/cs1302uga/cs1302-ce20)
1. [`cs1302-ce21` Fun with Components and Containers](https://github.com/cs1302uga/cs1302-ce21)
1. [`cs1302-ce22` Loading...](https://github.com/cs1302uga/cs1302-ce22)
1. [`cs1302-ce23` Java Stream API](https://github.com/cs1302uga/cs1302-ce23)
1. [`cs1302-ce24` Recursive Problems](https://github.com/cs1302uga/cs1302-ce24)
1. [`cs1302-ce25` Applications of Recursion](https://github.com/cs1302uga/cs1302-ce25)
1. [`cs1302-ce26` Tic-Tac-Toe Solver](https://github.com/cs1302uga/cs1302-ce26)
1. [`cs1302-ce27` Paired Sorting Algorithm Analysis](https://github.com/cs1302uga/cs1302-ce27)
1. [`cs1302-ce28` More Paired Sorting Algorithm Analysis](https://github.com/cs1302uga/cs1302-ce28)
1. [`cs1302-ce29` Complexity Classes](https://github.com/cs1302uga/cs1302-ce29)
1. [`cs1302-ce30` Social Network Graph Analytics](https://github.com/cs1302uga/cs1302-ce30)
1. [`cs1302-ce31` More Social Network Graph Analytics](https://github.com/cs1302uga/cs1302-ce31)
1. [`cs1302-ce32` Stream / Recursion Practice](https://github.com/cs1302uga/cs1302-ce32)

## How to Prepare

The best way to prepare for the class exercises is to actively engage with the reading 
quizzes, and the best way to prepare for the reading quizzes is to actively engage with 
the reading. This means that you should actually try the things that you're reading about
(e.g., commands, code, etc.), take notes as needed, and ask questions when things are unclear. 
To get the most out of a reading, you should do this even if the reading is not directly 
presented as a tutorial. Merely reading the words to prepare is rarely sufficient and is
widely considered the least effective way to prepare.  

## Publication History

| DOI | Tag | Date | Description |
|-----|-----|------|-------------|
| [10.5281/zenodo.2652509](https://doi.org/10.5281/zenodo.2652509) | NA        | NA           | All Versions |
| [10.5281/zenodo.3579498](https://doi.org/10.5281/zenodo.3579498) | `v2019fa` | Dec 16, 2019 | Fall 2019    |
| [10.5281/zenodo.2652510](https://doi.org/10.5281/zenodo.2652510) | `v2019sp` | Apr 26, 2019 | Spring 2019  |

## License

[![License: CC BY-NC 4.0](https://img.shields.io/badge/License-CC%20BY--NC%204.0-lightgrey.svg)](http://creativecommons.org/licenses/by-nc/4.0/) [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.2652509.svg)](https://doi.org/10.5281/zenodo.2652509)

<small>
Copyright &copy; Michael E. Cotterell, Bradley J. Barnes, and the University of Georgia.
This work is licensed under 
a <a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/">Creative Commons Attribution-NonCommercial 4.0 International License</a>.
The content and opinions expressed on this Web page do not necessarily reflect the views of nor are they endorsed by the University of Georgia or the University System of Georgia.
