# Required Readings
Reading List for CSCI 1302

## Reading 00

   Read and take thorough notes on the following:
   
   * [1302 Reference Variable Refresher](https://github.com/cs1302uga/cs1302-tutorials/blob/master/refresher/variables.md)
     
     Read the section titled "Reference Types Overview". For now, you can skip everything after Example 3 (unless you're curious!).
     This short reading addresses some misconceptions we've seen from students about prerequisite knowledge that we've seen in 
     past semesters. Please read it carefully and ask any related questions on Piazza.

## Reading 01
   
   You should complete one of the setup instructions provided below before you begin:

   * [MacOS Setup Instructions](../cs1302-exercises/blob/master/misc/MacOS.md)
   * [Windows 10 Setup Instructions](https://github.com/cs1302uga/cs1302-exercises/blob/master/misc/Windows10.md)

   Complete the setup instructions below for Odin:

   * [Odin Setup Instructions](../cs1302-exercises/blob/master/misc/OdinSetup.md)
   
   Read and take thorough notes on the following:

   Note: You are encouraged to try the commands mentioned in the reading using a local terminal in your terminal 
   emulator (set up in the previous step). Some of the file and directory structures assumed by the reading are 
   specific to the institution hosting the reading, however, the general commands will still work. You are always 
   encouraged to experiment. 

   * [An introduction to Unix](http://www.ee.surrey.ac.uk/Teaching/Unix/unixintro.html)
   * [Unix Tutorial One, Two, Three, and Four](http://www.ee.surrey.ac.uk/Teaching/Unix/)
      * In Tutorial Two, the instructions for 2.1 have you copy a file called science.txt. This file is not 
      available under the path provided by the tutorial. To partially mitigate this, we encourage you to download 
      the file into your home directory, then copy it from there:
      
      ```
      $ cd
      $ wget http://www.ee.surrey.ac.uk/Teaching/Unix/science.txt
      $ cd ~/unixstuff
      $ cp ~/science.txt .
      ```
      
## Reading 02

   We recommend following along with the tutorials on odin instead of your local machine. If you haven't already 
   completed the [Odin setup tutorial](https://github.com/cs1302uga/cs1302-exercises/blob/master/misc/OdinSetup.md), 
   you should do so before continuing.

   **Note:** This reading teaches you how to write/modify source code and then compile and run it in a Unix environment. 
   To be successful in 1302, you need to master the concepts described in this reading as all future projects/exercises 
   depend on it. 

   Read and take thorough notes on the following:

   * [Emacs Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/emacs/emacs.md)
   * [Emacs Reference Card](https://www.gnu.org/software/emacs/refcards/pdf/refcard.pdf) 
      * We recommend you print the Emacs reference card
   * [CSCI 1302 Package Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/packages.md)
      * The 1302 Package Tutorial explains how to compile code in a UNIX environment.
      
## Reading 03

   Read and take thorough notes on the following:

   * [Unix Tutorial Five](http://www.ee.surrey.ac.uk/Teaching/Unix/unix5.html)
   * [CSCI 1302 Octal Mode Reading](https://github.com/cs1302uga/cs1302-tutorials/blob/master/octal-mode.md)
   
## Reading 04

   Read, watch, and take thorough notes on the following:

   * [Exceptions Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/exceptions/exceptions.md)
   * [Command-Line Arguments Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/cla/cla.md)
   
## Reading 05

   Read and take thorough notes on the following:

   * [Javadoc and API Documentation Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/javadoc/javadoc.md)
   * [1302 Code Style Guidelines](https://github.com/cs1302uga/cs1302-styleguide)
      * Make sure you complete the setup for checkstyle and create the proper configuration file for emacs (or vi).
      
## Reading 06

   Read and take thorough notes on the following:

   * [Java Interfaces Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/interfaces/interfaces.md)
   
## Reading 07 
   **- CONSIDER CHANGING THIS - change to instead be an interface example with the Java List interface. Have them write a program 
   that uses the interface and then allow them to plug in different interface implementations (ArrayList, LinkedList) seamlessly. 
   The application could be a shopping list, for example. Would help the students see the driver program side early which might help
   them with project 2 (listadt).**

   Read and take thorough notes on the following:

   * [Default Methods Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/default-methods/default-methods.md)
   
## Reading 08

   Read and take thorough notes on the following:

   * [Inheritance Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/inheritance/inheritance.md)
   
## Reading 09

   **Note to self: Exercise 09 uses UML. Consider moving that reading up here.**
   Read and take thorough notes on the following:

   * [1302 Variable Refresher](https://github.com/cs1302uga/cs1302-tutorials/blob/master/refresher/variables.md)
      * This short reading addresses some misconceptions we've seen from students throughout the semester. Please read it carefully and ask any related questions on Piazza.
   * [Pro Git Ch. 1.1--1.4 and 1.7](https://git-scm.com/book/en/v2/Getting-Started-About-Version-Control)

## Reading 10

   Read and take thorough notes on the following:

   * [UML Reading](https://github.com/cs1302uga/cs1302-tutorials/blob/master/uml/uml.md)
   * [Visibility Reading](https://github.com/cs1302uga/cs1302-tutorials/blob/master/visibility/visibility.md)
   
## Reading 10.5

   Read and take thorough notes on the following:

   * [ADTs and Lists Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/adt-and-links/adt-and-links.md)
   * [List ADT Project Description](https://github.com/cs1302uga/cs1302-listadt)
   * [StringList Interface API Documentation](http://cobweb.cs.uga.edu/~mec/cs1302/listadt-api/)
   
## Reading 11

   Read and take thorough notes on the following:

   * [VarArgs Reading](https://github.com/cs1302uga/cs1302-tutorials/blob/master/varargs/varargs.md)
   
We highly recommend reading the following closely for a second time:

   * [ADTs and Lists Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/adt-and-links/adt-and-links.md)
   * [List ADT Project Description](https://github.com/cs1302uga/cs1302-listadt)
   * [StringList Interface API Documentation](http://cobweb.cs.uga.edu/~mec/cs1302/listadt-api/)

## EXAM BREAK

## Reading 12

   Read and take thorough notes on the following:

   * [The Object Class](https://github.com/cs1302uga/cs1302-tutorials/blob/master/inheritance/inheritance.md#the-object-class)
   * The extremely short and infinitely beneficial [1302 Scripts Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/scripts/scripts.md)
       * Common reaction to this reading: "Whoa!"

## Reading 13

   Read and take thorough notes on the following:

   * [1302 Generic Classes Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/generics/generic-classes/generic-classes.md)
   * [The Java™ Tutorials: Why Use Generics?](https://docs.oracle.com/javase/tutorial/java/generics/why.html)
   * [The Java™ Tutorials: Generic Types](https://docs.oracle.com/javase/tutorial/java/generics/types.html)
   * [The Java™ Tutorials: Raw Types](https://docs.oracle.com/javase/tutorial/java/generics/rawTypes.html)
   
## Reading 13.5

   Read and take thorough notes on the following:

   * [Pro Git Ch. 2.1--2.4](https://git-scm.com/book/en/v2/Git-Basics-Getting-a-Git-Repository)
   * [Pro Git Ch. 3.1--3.4](https://git-scm.com/book/en/v2/Git-Branching-Branches-in-a-Nutshell)

   **Please Note:** A branch's history does not begin at its branching point. The commit history of a branch includes the 
   latest commit in the branch as well as all commits that can be reached by tracing backward through the commit history 
   (even through branching points). When tracing a branch's history using the graphical log output (--graph), you should 
   not stop at the point where the branch name was created (or any other branching points).

## Reading 14

   Read and take thorough notes on the following:

   * [1302 Generic Methods Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/generics/generic-methods/generic-methods.md)
   * [The Java™ Tutorials: Generic Methods](https://docs.oracle.com/javase/tutorial/java/generics/methods.html)
   * [The Java™ Tutorials: Bounded Type Parameters](https://docs.oracle.com/javase/tutorial/java/generics/bounded.html)
   * [The Java™ Tutorials: Generic Methods and Bounded Type Parameters](https://docs.oracle.com/javase/tutorial/java/generics/boundedTypeParams.html)
   * [The Java™ Tutorials: Generics, Inheritance, and Subtypes](https://docs.oracle.com/javase/tutorial/java/generics/inheritance.html)
   
## Reading 15

   Read and take thorough notes on the following:

   * [The Java™ Tutorials: Lambda Expressions: Ideal Use Case for Lambda Expressions](https://docs.oracle.com/javase/tutorial/java/javaOO/lambdaexpressions.html#use-case) (through the end of the "Approach 5" sub-section)
   * [Package java.util.function Description](https://docs.oracle.com/javase/8/docs/api/java/util/function/package-summary.html#package.description) (familiarize yourself with the classes and interfaces)
   * [@FunctionalInterface API Documentation](https://docs.oracle.com/javase/8/docs/api/java/lang/FunctionalInterface.html) (read this entire page; it's roughly one paragraph)
   
## Reading 16

   Read and take thorough notes on the following:

   * [The Java™ Tutorials: Lambda Expressions](https://docs.oracle.com/javase/tutorial/java/javaOO/lambdaexpressions.html)
      * This reading is a continuation of last week's reading on lambda expressions. Make sure you go through each of the nine approaches carefully,
         type out the code for each method, call the methods to test them, take notes, and write down questions.
      * The tutorial provides a link to all of the code used in the examples. If the code you type out isn't working properly, you can use this as a reference.
      
## Reading 17

   Read and take thorough notes on the following:

   * [CSCI 1302 Generic Types Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/generics/generic-types/generic-types.md)
      * This is a brief exercise that should clarify some of the questions brought up in last week's exercises on generics.
   * [Project 3 Description](https://github.com/cs1302uga/cs1302-genlistadt)
   * [GenList<T> API Documentation](http://cobweb.cs.uga.edu/~mec/cs1302-genlistadt-doc/index.html)
   
## Reading 18

   Read and take thorough notes on the following:

   * [Method References](https://dzone.com/articles/methodreference)
      * Project Specific Use of Method References: [example1](http://csweb.cs.uga.edu/~mec/cs1302-genlistadt-doc/cs1302/genlistadt/GenList.html#min-java.util.Comparator-)
        , [example2](http://csweb.cs.uga.edu/~mec/cs1302-genlistadt-doc/cs1302/genlistadt/GenList.html#toArray-java.util.function.IntFunction-)
   * [Project 3 Description](https://github.com/cs1302uga/cs1302-genlistadt)
   * [GenList<T> API Documentation](http://cobweb.cs.uga.edu/~mec/cs1302-genlistadt-doc/index.html)
      * Yes, we want you to read through this again.
   * [Lambda Expressions](https://docs.oracle.com/javase/tutorial/java/javaOO/lambdaexpressions.html)
      * We want you all to read this tutorial one more time (at least). Understanding lambda expressions is vital to working with 
        JavaFX Graphical User Interfaces.
   
## Reading 19
   
   JavaFX is a set of graphics and media packages that enables developers to design, create, test, debug, and deploy rich client 
   applications that operate consistently across diverse platforms. 
   
   Please fully engage with the following readings related to JavaFX:

   * [CSCI 1302 JavaFX Starter Tutorial](https://github.com/cs1302uga/cs1302-tutorials/blob/master/javafx/javafx.md)
      * This is critical to run GUI applications on Odin. This is also critical for the next project so each individual needs to complete it.
   * [javafx.application.Application API Documentation](https://docs.oracle.com/javase/8/javafx/api/javafx/application/Application.html)
      * Carefully read the introduction and compile/run the example code on Odin.
