/*
 * Decompiled with CFR 0.152.
 */
package cs1302.util;

import java.util.Arrays;
import java.util.Comparator;

public final class ArrayUtility {
    private ArrayUtility() {
    }

    public static <T extends Comparable<T>> void sort(T[] TArray) {
        ArrayUtility.checkNull("a", TArray);
        Arrays.sort(TArray);
    }

    public static <T> void sort(T[] TArray, Comparator<T> comparator) {
        ArrayUtility.checkNull("a", TArray);
        ArrayUtility.checkNull("c", comparator);
        Arrays.sort(TArray, comparator);
    }

    public static <T> T max(T[] TArray, Comparator<T> comparator) {
        ArrayUtility.checkArray("a", TArray);
        T t = TArray[0];
        for (T t2 : TArray) {
            if (comparator.compare(t2, t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T extends Comparable<T>> T max(T[] TArray) {
        ArrayUtility.checkArray("a", TArray);
        T t = TArray[0];
        for (T t2 : TArray) {
            if (t2.compareTo(t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    private static <T> void checkArray(String string, T[] TArray) {
        if (TArray == null) {
            throw new NullPointerException(String.format("%s cannot be null", string));
        }
        if (TArray.length == 0) {
            throw new IllegalArgumentException(String.format("%s must contain at least one value", string));
        }
    }

    private static <T> void checkNull(String string, T t) {
        if (t == null) {
            throw new NullPointerException(String.format("%s cannot be null", string));
        }
    }
}

