import java.io.*;
import java_cup.runtime.*;

class P4 {

	public static void
	main(String args[]) throws java.io.IOException,  Exception {

		if (args.length != 1) {
			System.out.println("Error: Input file must be named on command line." );
			System.exit(-1);
		}

		java.io.Reader yyin = null;

		try {
			yyin = new BufferedReader(new FileReader(args[0]));
		} catch (FileNotFoundException notFound){
			System.out.print("Error: unable to open input file: ");
			System.out.println(args[0]);
			System.exit(1); // 1 means failure
		}

		Scanner.init(yyin); // Initialize Scanner class for parser
		final parser csxParser = new parser();
		System.out.println ("\n\n" + "Begin CSX_lite compilation of " + args[0] + ".\n");
		Symbol root=null;
		try {
			root = csxParser.parse(); // do the parse
			System.out.println ("CSX_lite program parsed correctly.");
		} catch (SyntaxErrorException e) {
			System.out.println ("Compilation terminated due to syntax errors.");
			System.exit(0);
		}

		final boolean ok = ((csxLiteNode)root.value).isSemanticsCorrect();
		if (ok) {
			System.out.println("No CSX_lite semantics errors detected.");
		} else {
			System.out.println("\nCSX compilation halted due to semantics errors.");
		}
	} // main
} // class P4
