#include <bits/stdc++.h>
using namespace std;
#define lld long long

const int mx = 1e5+5;
int n, p[mx], gp[mx];
lld T, a[mx], d[mx];
set<int> roots;
lld dis[mx], lep[mx];
lld krugDis[mx], krugVal[mx];
int g = 0;

int rmark[mx];
void cycleFound(int x) {
    g++;
    int s = x;
    do {
        x = p[x];
        roots.insert(x);
        rmark[x] = 2;
        krugVal[g] += a[x];
        krugDis[g] += d[x];
        gp[x] = g;
    } while (x != s);
}
void dfsRoots(int x) {
    if (rmark[p[x]] == 2)
        return;
    if (rmark[p[x]] == 1) {
        cycleFound(p[x]);
    }
    else {
        rmark[p[x]] = 1;
        dfsRoots(p[x]);
    }
    rmark[x] = 2;
}

void findDis(int x) {
    if (roots.count(p[x])) {
        dis[x] = d[x];
        lep[x] = a[x];
        gp[x] = p[x];
        return;
    }
    if (dis[p[x]] == 0)
        findDis(p[x]);
    dis[x] = d[x] + dis[p[x]];
    lep[x] = a[x] + lep[p[x]];
    gp[x] = gp[p[x]];
}

lld query(int x, lld t) {
    int g = gp[x];
    lld ans = krugVal[g] * (t / krugDis[g]);
    t %= krugDis[g];
    /*
    while (t - d[x] >= 0) {
        t -= d[x];
        ans += a[x];
        x = p[x];
    }
    */
    return ans + a[x];
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr); cout.tie(nullptr);

    cin >> n >> T;
    for (int i = 1; i <= n; i++)
        cin >> a[i];
    for (int i = 1; i <= n; i++)
        cin >> p[i];
    for (int i = 1; i <= n; i++)
        cin >> d[i];
    
    return 0;
    
    /// find roots
    for (int i = 1; i <= n; i++) {
        if (!rmark[i]) {
            rmark[i] = 1;
            dfsRoots(i);
        }
    }

    /// find distances
    for (int i = 1; i <= n; i++) {
        if (!roots.count(i) && !dis[i])
            findDis(i);
    }

    /*
    for (auto it = roots.begin(); it != roots.end(); it++)
        cout << *it << ' ';
    cout << '\n';
    for (int i = 1; i <= g; i++) {
        cout << krugDis[i] << ' ' << krugVal[i] << '\n';
    }
    cout << '\n';
    for (int i = 1; i <= n; i++) {
        cout << gp[i] << ' ' << dis[i] << '\n';
    }
    */

    //return 0;

    /// find ans
    lld ans = 0;
    for (int i = 1; i <= n; i++) {
        lld tans = 0;
        if (roots.count(i)) {
            tans = query(i, T);
        } else {
            tans = lep[i] + query(gp[i], T - dis[i]);
        }
        ans = max(ans, tans);
    }

    cout << ans;
}