#include <iostream>
#include <cstdio>
#include <cmath>

using namespace std;

typedef struct TREE{
private:
    int *x, *y, l;

    int findSize(int n){
        return pow(2, ceil(log(n)/log(2)));
    }

    int minI(int p, int q, int a, int b, int v){
        if(q < p)
            return 0;
        if(p == q)
            return x[p + l - 1];
        if(p == a && q == b)
            return x[v];
        int t = (a + b) / 2;
        if(q <= t)
            return minI(p, q, a, t, 2 * v + 1);
        if(p > t)
            return minI(p, q, t + 1, b, 2 * v + 2);
        int t1 = minI(p, t, a, t, 2 * v + 1), t2 = minI(t + 1, q, t + 1, b, 2 * v + 2);
        if(y[t1] < y[t2])
            return t1;
        if(y[t1] > y[t2])
            return t2;
        return min(t1, t2);
    }
public:
    TREE(int n){
        l = findSize(n);
        x = new int[2*l - 1];
        y = new int[l];

        for(int i = 0; i < n; i++)
            scanf("%d", y + i);
        for(int i = n; i < l; i++)
            y[i] = INT_MAX;

        for(int i = l - 1; i < n + l - 1; i++)
            x[i] = i - l + 1;
        for(int i = n + l - 1; i < 2 * l - 1; i++)
            x[i] = l - 1;
        for(int i = l - 2; i >= 0; i--)
            if(y[x[2 * i + 1]] <= y[x[2 * i + 2]])
                x[i] = x[2 * i + 1];
            else
                x[i] = x[2 * i + 2];
    }

    int at(int p){
        return y[p];
    }

    int minI(int p, int q){
        return minI(p, q, 0, l - 1, 0);
    }

    void output(){
        for(int i = 0; i < 2 * l - 1; i++)
            printf("%d ", x[i]);
    }
}tree;

int main(){
    int n, k;
    cin >> n >> k;
    tree x(n);
    //x.output();

    k = n - k;
    for(int i = 0, j = 0; i < k; i++){
        int t = x.minI(j, n - k + i);
        printf("%d ", x.at(t));
        j = t + 1;
    }
    //cout << endl;
    //x.output();

    return 0;
}