#include <bits/stdc++.h>
using namespace std;

struct Point{
    int x, y;
};

int mat[505][505];
bool visited[505][505];

Point start;
Point finish;

int n, m;

Point closestTo(int x, int y, int getToX, int getToY){
    if(x < 0 || y < 0 || x >= n || y >= n || mat[x][y] == 1 || visited[x][y]){
        return {987654321, 987654321};
    }

    visited[x][y] = true;
    int minDist = abs(getToX - x) + abs(getToY - y);
    Point toRet = Point{x, y};


    Point p1 = closestTo(x + 1, y, getToX, getToY);
    Point p2 = closestTo(x - 1, y, getToX, getToY);
    Point p3 = closestTo(x, y + 1, getToX, getToY);
    Point p4 = closestTo(x, y - 1, getToX, getToY);

    if(minDist > abs(getToX - p1.x) + abs(getToY - p1.y)){
        toRet = p1;
        minDist = abs(getToX - p1.x) + abs(getToY - p1.y);
    }
    if(minDist > abs(getToX - p2.x) + abs(getToY - p2.y)){
        toRet = p2;
        minDist = abs(getToX - p2.x) + abs(getToY - p2.y);
    }
    if(minDist > abs(getToX - p3.x) + abs(getToY - p3.y)){
        toRet = p3;
        minDist = abs(getToX - p3.x) + abs(getToY - p3.y);
    }
    if(minDist > abs(getToX - p4.x) + abs(getToY - p4.y)){
        toRet = p4;
        minDist = abs(getToX - p4.x) + abs(getToY - p4.y);
    }

    return toRet;
}

int main()
{
    cin >> n >> m;

    for(int i = 0; i < n; ++i){
        for(int j = 0; j < n; ++j){
            char c;
            cin >> c;
            if(c == '.'){
                mat[i][j] = 0;
            }else if(c == 'X'){
                mat[i][j] = 1;
            }else if(c == 'A'){
                mat[i][j] = 2;
                start = Point{i, j};
            }else if(c == 'B'){
                mat[i][j] = 3;
                finish = Point{i, j};
            }
        }
    }

    Point clp1;
    Point clp2;

    {
        Point p1 = closestTo(start.x, start.y, finish.x, finish.y);
        for(int i = 0; i < n; ++i){
            for(int j = 0; j < n; ++j){
                visited[i][j] = false;
            }
        }
        Point p2 = closestTo(finish.x, finish.y, p1.x, p1.y);
        for(int i = 0; i < n; ++i){
            for(int j = 0; j < n; ++j){
                visited[i][j] = false;
            }
        }
        int dist1 = abs(p1.x - p2.x) + abs(p1.y - p2.y);

        Point p3 = closestTo(finish.x, finish.y, start.x, start.y);
        for(int i = 0; i < n; ++i){
            for(int j = 0; j < n; ++j){
                visited[i][j] = false;
            }
        }
        Point p4 = closestTo(start.x, start.y, p3.x, p3.y);
        int dist2 = abs(p3.x - p4.x) + abs(p3.y - p4.y);

        if(dist1 <= dist2){
            clp1 = p1;
            clp2 = p2;
        }else{
            clp1 = p3;
            clp2 = p4;
        }
    }

    int clpDist = max(abs(clp1.x - clp2.x), abs(clp1.y - clp2.y)) - 1;
    if(m == 1){
        cout << clpDist << "\n";
    }else{
        if(clpDist % 2 == 1){
            clpDist++;
        }
        clpDist /= 2;
        cout << clpDist << "\n";
    }
    return 0;
}