#include <iostream>
#include <vector>
#include <cstddef>
#include <array>
#include <bitset>

using Numbers = std::vector<long>;

using States = std::array<std::vector<long>, 20>;

States preprocess(Numbers const& numbers)
{
    States states;

    for (auto& state : states)
    {
        state.resize(numbers.size());
    }

    for (std::size_t i = 0; i < numbers.size(); ++i)
    {
        auto n = numbers[i];
        int b = 0;
        while (n)
        {
            if (n & 1)
            {
                states[b][i] = 1;
            }

            n >>= 1;
            ++b;
        }
    }

    for (auto& state : states)
    {
        for (auto i = state.begin() + 1; i != state.end(); ++i)
        {
            *i += *(i - 1);
        }
    }

    for (auto& state : states)
    {
        for (auto& i : state)
        {
            if (i == 0)
            {
                i = -1000000;
            }
        }
    }

    /*
    for (auto const& state : states)
    {
        for (auto const i : state)
        {
            std::cout << i << ' ';
        }
        std::cout << '\n';
    }
    */

    return states;
}

long solve(States const& states, long left, long right)
{
    // std::cout << "--------\n";

    long result = 0;

    long const sz = right - left;

    for (int bit = 0; bit < 20; ++bit)
    {
        // std::cout << std::bitset<20>(result) << '\n';
        long const diff = states[bit][right] - states[bit][left];
        // std::cout << states[bit][right] << ", " << states[bit][left] << " => " << diff << ", sz " << sz << '\n';
        if (diff == sz)
        {
            result |= (1 << bit);
        }
    }

    return result;
}

int main()
{
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    std::size_t N;
    long num_queries;
    std::cin >> N >> num_queries;

    Numbers direct(N);

    for (auto& n : direct)
    {
        std::cin >> n;
    }

    auto const states = preprocess(direct);

    for (long i = 0; i < num_queries; ++i)
    {
        long left;
        long right;

        std::cin >> left >> right;

        --left;
        --right;

        std::cout << solve(states, left, right) << '\n';
    }
}