#include <iostream>
#include <vector>
#include <utility>
#include <array>

using Matrix = std::vector<std::vector<char>>;

using Seen = std::vector<std::vector<int>>;

void print_matrix(Matrix const& matrix)
{
    /*
    std::cout << "-------\n";
    for (auto const& row : matrix)
    {
        for (auto const c : row)
        {
            std::cout << c;
        }
        std::cout << '\n';
    }
    */
}

std::pair<int, int> find_start(Matrix const& matrix)
{
    for (int x = 0; x < (int)matrix.size(); ++x)
    {
        for (int y = 0; y < (int)matrix.size(); ++y)
        {
            if (matrix[x][y] == 'A')
            {
                return {x, y};
            }
        }
    }

    return {0, 0};
}

Seen empty_seen(Matrix const& matrix)
{
    return Seen(matrix.size(), std::vector<int>(matrix.size()));
}

bool path_exists(Matrix const& matrix, Seen& seen, int x, int y)
{
    if (x < 0 || x >= (int)matrix.size() || y < 0 || y >= (int)matrix.size())
    {
        return false;
    }

    if (seen[x][y])
    {
        return false;
    }

    if (matrix[x][y] == 'B')
    {
        return true;
    }

    if (matrix[x][y] == 'X')
    {
        return false;
    }

    seen[x][y] = true;

    if (path_exists(matrix, seen, x + 1, y) || path_exists(matrix, seen, x - 1, y) || path_exists(matrix, seen, x, y + 1) || path_exists(matrix, seen, x, y - 1))
    {
        return true;
    }

    seen[x][y] = false;
    return false;
}

void clear(Matrix& matrix, int i, int start_x, int start_y)
{
    for (int dx = -i; dx <= i; ++dx)
    {
        for (int dy = -i; dy <= i; ++dy)
        {
            if (dx == 0 || dy == 0)
            {
                continue;
            }

            auto const x = start_x + dx;
            auto const y = start_y + dy;

            if (x < 0 || x >= (int)matrix.size() || y < 0 || y >= (int)matrix.size())
            {
                continue;
            }

            if (matrix[x][y] == 'B')
            {
                continue;
            }

            matrix[x][y] = '.';
        }
    }
}

int solve(Matrix& matrix)
{
    int result = 0;

    auto const start = find_start(matrix);

    static std::array<int, 5> ddx {0, 1, -1, 0, 0};
    static std::array<int, 5> ddy {0, 0, 0, 1, -1};

    for (result = 0; result < (int)matrix.size(); ++result)
    {
        for (std::size_t i = 0; i < ddx.size(); ++i)
        {
            auto const x = start.first + ddx[i];
            auto const y = start.second + ddy[i];

            if (x < 0 || x >= (int)matrix.size() || y < 0 || y >= (int)matrix.size())
            {
                continue;
            }

            if (matrix[x][y] == 'X')
            {
                continue;
            }

            Matrix cp(matrix);

            clear(cp, result, x, y);

            //std::cout << result << '\n';
            print_matrix(cp);

            auto seen = empty_seen(cp);
            if (path_exists(cp, seen, start.first, start.second))
            {
                return result;
            }
        }
    }

    return result;
}

int main()
{
    //std::ios::sync_with_stdio(false);
    //std::cin.tie(nullptr);

    int num_mines;
    int dim;

    std::cin >> dim >> num_mines;

    if (num_mines == 1)
    {
        Matrix matrix(dim, std::vector<char>(dim));
        for (auto& row : matrix)
        {
            for (auto& i : row)
            {
                std::cin >> i;
            }
        }

        std::cout << solve(matrix) << '\n';
    }
}