#include <algorithm>
#include <cstdio>
#include <unordered_map>
#include <vector>
#define MAXN 500007
// #define DEBUG

using namespace std;

int A[MAXN];
int S[MAXN];
vector<int> sorted;
unordered_map<int, vector<int>> occurences;
unordered_map<int, int> currentIndex;

/*
4 1
4 8 6 3

8 3
6 0 3 1 4 2 1 7

20 5
6 3 7 2 8 3 6 2 7 3 7 4 9 6 9 0 4 7 3 8

4 100
4 8 6 3
*/

int main() {
    // Input.
    int N, K;
    scanf("%d %d", &N, &K);
    for (int i = 0; i < N; ++i) {
        scanf("%d", &A[i]);
        S[i] = A[i];
        occurences[A[i]].push_back(i);
    }
    // Sorting.
    sort(S, S + N);
    int last = -1;
    for (int i = 0; i < N; ++i) {
        if (S[i] != last) {
            last = S[i];
            currentIndex[S[i]] = 0;
            sorted.push_back(S[i]);
        }
    }
    // Loop.
    int index = 0;
    while (K > 0 && index < N) {
        #ifdef DEBUG
        printf("Looping with K/index: %d %d\n", K, index);
        #endif
        bool found = false;
        for (int currentMin = 0; currentMin < sorted.size() && !found; ++currentMin) {
            int currentMinValue = sorted[currentMin];
            #ifdef DEBUG
            printf("Current min: %d (%d)\n", currentMin, currentMinValue);
            #endif
            for (int i = currentIndex[currentMinValue]; i < occurences[currentMinValue].size(); ++i) {
                int occurence = occurences[currentMinValue][i];
                #ifdef DEBUG
                printf("Occurence: %d\n", occurence);
                #endif
                if (occurence - index > K) {
                    #ifdef DEBUG
                    printf("Occurence unreachable.\n");
                    #endif
                    break;
                } else if (occurence < index) {
                    #ifdef DEBUG
                    printf("Occurence was before.\n");
                    #endif
                    ++currentIndex[currentMinValue];
                } else {
                    #ifdef DEBUG
                    printf("Found.\n");
                    #endif
                    K -= occurence - index;
                    index = occurence + 1;
                    printf("%d ", A[occurence]);
                    found = true;
                    break;
                }
            }
        }
    }
    for (int i = index; i < N; ++i) {
        printf("%d ", A[i]);
    }
    return 0;
}