#include <cstdio>
#include <vector>
#define MAXN 10007
// #define DEBUG

/*
5 7
7 3 1 4 8
4 3 5 2 1
3 2 4 1 7

5 1000
7 3 1 4 8
4 3 5 2 1
3 2 4 1 7

6 200
1 1 1 1 1 100
3 1 2 5 4 5
1 1 1 10 10 1

6 200
1 1 1 1 1 100
3 1 2 5 6 4
1 1 1 10 10 1
*/

using namespace std;

typedef struct {
    int lepota;
    int duzina;
    bool incomplete;
    vector<int> cvorovi;
} Loop;

int O[MAXN];
// X[i] je pocetna pozicija puta koji se zavrsava u i.
int X[MAXN];
// Y[i] je krajnja pozicija puta koji pocinje u i.
int Y[MAXN];
// D[i] je duzina puta koji se zavrsava u i.
int D[MAXN];
// D2[i] je duzina puta koji pocinje u i.
int D2[MAXN];
bool markiran[MAXN];
Loop loops[MAXN];

int main() {
    // Input.
    int N, T;
    scanf("%d %d", &N, &T);
    for (int i = 1; i <= N; ++i) {
        loops[i].duzina = 0;
        loops[i].lepota = 0;
        scanf("%d", &O[i]);
    }
    for (int i = 1; i <= N; ++i) {
        scanf("%d", &X[i]);
        Y[X[i]] = i;
    }
    for (int i = 1; i <= N; ++i) {
        scanf("%d", &D[i]);
        D2[X[i]] = D[i];
    }
    #ifdef DEBUG
    for (int i = 1; i <= N; ++i) {
        printf("%d %d %d %d %d\n", O[i], X[i], Y[i], D[i], D2[i]);
    }
    #endif
    // Loop detection.
    int loopIndex = 0;
    for (int i = 1; i <= N; ++i) {
        int index = i;
        if (!markiran[index]) {
            while (!markiran[index]) {
                loops[loopIndex].cvorovi.push_back(index);
                loops[loopIndex].duzina += D[index];
                loops[loopIndex].lepota += O[index];
                markiran[index] = true;
                index = X[index];
            }
            loops[loopIndex].incomplete = (loops[loopIndex].cvorovi[0] != index);
            ++loopIndex;
        }
    }
    // Loop through loops.
    int maxLoopLepota = 0;
    for (int j = 0; j < loopIndex; ++j) {
        Loop loop = loops[j];
        if (loop.incomplete) {
            continue;
        }
        #ifdef DEBUG
        printf("At loop %d. (%d, %d, %d, %d)\n", j, loop.duzina, loop.lepota, loop.cvorovi.size(), loop.incomplete);
        for (int i = 0; i < loop.cvorovi.size(); ++i) {
            printf("%d ", loop.cvorovi[i]);
        }
        printf("\n");
        #endif
        int preostalo = T % loop.duzina,
            krugova = T / loop.duzina,
            maxLepota = 0;
        for (int i : loop.cvorovi) {
            int tpreostalo = preostalo,
                trenutni = i,
                trenutnaLepota = 0;
            while (tpreostalo >= 0) {
                trenutnaLepota += O[trenutni];
                tpreostalo -= D[trenutni];
                trenutni = X[trenutni];
            }
            if (trenutnaLepota > maxLepota) {
                maxLepota = trenutnaLepota;
            }
        }
        int loopLepota = krugova * loop.lepota + maxLepota;
        if (loopLepota > maxLoopLepota) {
            maxLoopLepota = loopLepota;
        }
    }
    printf("%d", maxLoopLepota);
    return 0;
}