#include <iostream>
#include <bits/stdc++.h>

using namespace std;

#define MAXN 505

int dirx[4] = {0, 0, 1, -1};
int diry[4] = {1, -1, 0, 0};
int dirx8[8] = {0, 0, 1, -1, 1, -1, 1, -1};
int diry8[8] = {1, -1, 0, 0, 1, -1, -1, 1};

int n, m;
char matrix[MAXN][MAXN];
bool visited[MAXN][MAXN];
int Adist[MAXN][MAXN];
int Bdist[MAXN][MAXN];

int main()
{
    ios_base::sync_with_stdio(false); cin.tie(0);
    cin >> n >> m;

    char c;

    queue<pair<int,int> > A;
    queue<pair<int,int> > B;

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            cin >> c;
            matrix[i][j] = c;
            if (c == 'A') {
                A.push(make_pair(i, j));
            }
            else if (c == 'B') {
                B.push(make_pair(i, j));
            }
        }
    }

    memset(Adist, 0x3f3f3f3f, sizeof Adist);


    // find A cc
    queue<pair<int,int> > acc;
    int nx, ny;
    pair<int,int> cur;
    while (!A.empty()) {
        cur = A.front(); A.pop();
        Adist[cur.first][cur.second] = 0;
        acc.push(cur);

        for (int i = 0; i < 4; i++) {
            nx = cur.first + dirx[i];
            ny = cur.second + diry[i];

            if (nx < 0 || ny < 0 || nx >= n || ny >= n || visited[nx][ny]) continue;

            if (matrix[nx][ny] == '.') {
                A.push(make_pair(nx, ny));
                visited[nx][ny] = true;
            }
        }
    }

    // compute Adist
    while (!acc.empty()) {
        cur = acc.front(); acc.pop();

        for (int i = 0; i < 8; i++) {
            nx = cur.first + dirx8[i];
            ny = cur.second + diry8[i];

            if (nx < 0 || ny < 0 || nx >= n || ny >= n) continue;

            if (Adist[cur.first][cur.second] + 1 < Adist[nx][ny]) {
                Adist[nx][ny] = Adist[cur.first][cur.second] + 1;
                acc.push(make_pair(nx, ny));
            }
        }
    }

    //// zzzzzzz

    memset(Bdist, 0x3f3f3f3f, sizeof Bdist);

    // find B cc
    queue<pair<int,int> > bcc;
    while (!B.empty()) {
        cur = B.front(); B.pop();
        Bdist[cur.first][cur.second] = 0;
        bcc.push(cur);

        for (int i = 0; i < 4; i++) {
            nx = cur.first + dirx[i];
            ny = cur.second + diry[i];

            if (nx < 0 || ny < 0 || nx >= n || ny >= n || visited[nx][ny]) continue;

            if (matrix[nx][ny] == '.') {
                B.push(make_pair(nx, ny));
                visited[nx][ny] = true;
            }
        }
    }

    // compute Bdist
    while (!bcc.empty()) {
        cur = bcc.front(); bcc.pop();

        for (int i = 0; i < 8; i++) {
            nx = cur.first + dirx8[i];
            ny = cur.second + diry8[i];

            if (nx < 0 || ny < 0 || nx >= n || ny >= n) continue;

            if (Bdist[cur.first][cur.second] + 1 < Bdist[nx][ny]) {
                Bdist[nx][ny] = Bdist[cur.first][cur.second] + 1;
                bcc.push(make_pair(nx, ny));
            }
        }
    }

    int res = 0x3f3f3f3f;
    for (int i = 0; i < n; i ++) {
        for (int j = 0; j < n; j++) {
            res = min(res, max(Adist[i][j], Bdist[i][j]));
        }
    }
    cout << res;

//    for (int i = 0; i < n; i ++) {
//        for (int j = 0; j < n; j++) {
//            cout << Adist[i][j] << " ";
//        }
//        cout << endl;
//    }
//    for (int i = 0; i < n; i ++) {
//        for (int j = 0; j < n; j++) {
//            cout << Bdist[i][j] << " ";
//        }
//        cout << endl;
//    }


    queue<pair<int,int> > tmp;



    return 0;
}