#include <iostream>
#include <vector>
#include <string>

void flip_row(std::vector<bool>& zid, int y, int m) {
	for(int x = 0; x < m; x++) {
		zid[y * m + x] = !zid[y * m + x];
	}
}

int zbir(std::vector<bool>& zid, int m, int n) {
	int konacno = 0;
	for(int x = 0; x < m; x++) {
		int prazan = 0;
		int obojen = 0;
		for(int y = 0; y < n; y++) {
			if(zid[y * m + x]) {
				obojen++;
			}else{
				prazan++;
			}
		}
		konacno += prazan*obojen;
	}
	return konacno;
}

int main() {
	std::string line;
	getline(std::cin, line);

	int n = std::stoi(line.substr(0, line.find(" ")));
	int m = std::stoi(line.substr(line.find(" ")+1));

	std::vector<bool> zid;
	zid.resize(m*n);

	std::vector<unsigned int> broj;

	for(int i = 0; i < n; i++) {
		std::string l;
		getline(std::cin, l);
		broj.push_back(std::stoi(l));
	}

	for(int y = 0; y < n; y++) {
		int b = broj[y];
		for(int i = 0; i < b; i++) {
			zid[y * m + i] = true;
		}
	}

	int najmanje = zbir(zid, m, n);

	for(int i = 0; i < n; i++) {
		for(int j = 0; j < n - i; j++) {
			flip_row(zid, j, m);
			int z = zbir(zid, m, n);
			if(z < najmanje) {
				najmanje = z;
			}else{
				flip_row(zid, j, m);
			}
		}
	}

	std::cout << najmanje << '\n';

	return 0;
}