#include <iostream>
#include <vector>
#include <string>

bool stavi_pored_kocke(std::vector<int>& tabla, int x, int y, int m, int n) {
	int broj = tabla[y * m + x];
	int postojece = 0;

	if(x > 0) {
		if(tabla[y * m + x-1] == 7) {postojece++;}
	}

	if(x < m-1) {
		if(tabla[y * m + x+1] == 7) {postojece++;}
	}

	if(y > 0) {
		if(tabla[(y-1) * m + x] == 7) {postojece++;}
	}

	if(y < n-1) {
		if(tabla[(y+1) * m + x] == 7) {postojece++;}
	}

	if(postojece == broj) {
		return false;
	}else{
		return true;
	}
}

bool ostali_topovi(std::vector<int>& tabla, int x, int y, int m, int n) {
	for(int i = x; i >= 0; i--) {
		if(tabla[y * m + i] == 7) {
			return false;
		}else if(tabla[y * m + i] != 6 && tabla[y * m + i] != 8) {
			break;
		}
	}

	for(int i = x; i < m; i++) {
		if(tabla[y * m + i] == 7) {
			return false;
		}else if(tabla[y * m + i] != 6 && tabla[y * m + i] != 8) {
			break;
		}
	}

	for(int i = y; i >= 0; i--) {
		if(tabla[i * m + x] == 7) {
			return false;
		}else if(tabla[i * m + x] != 6 && tabla[i * m + x] != 8) {
			break;
		}
	}

	for(int i = y; i < n; i++) {
		if(tabla[i * m + x] == 7) {
			return false;
		}else if(tabla[i * m + x] != 6 && tabla[i * m + x] != 8) {
			break;
		}
	}

	return true;
}

void napisi_tablu(std::vector<int>& tabla, int m, int n) {
	for(int y = 0; y < n; y++) {
		for(int x = 0; x < m; x++) {
			switch(tabla[y * m + x]) {
				case 0:
					std::cout << 0;
					break;
				case 1:
					std::cout << 1;
					break;
				case 2:
					std::cout << 2;
					break;
				case 3:
					std::cout << 3;
					break;
				case 4:
					std::cout << 4;
					break;
				case 5:
					std::cout << "#";
					break;
				case 7:
					std::cout << "C";
					break;
				default:
					std::cout << ".";
					break;
			}
		}
		std::cout << '\n';
	}
}

bool proveri_top(std::vector<int>& tabla, int x, int y, int m, int n) {
	bool k1 = true;
	bool k2 = true;
	bool k3 = true;
	bool k4 = true;
	bool k5 = true;

	if(x > 0 && tabla[y * m + x-1] < 5) {
		k1 = stavi_pored_kocke(tabla, x-1, y, m, n);
	}

	if(x < m-1 && tabla[y * m + x+1] < 5) {
		k2 = stavi_pored_kocke(tabla, x+1, y, m, n);
	}

	if(y > 0 && tabla[(y-1) * m + x] < 5) {
		k3 = stavi_pored_kocke(tabla, x, y-1, m, n);
	}

	if(y < n-1 && tabla[(y+1) * m + x] < 5) {
		k4 = stavi_pored_kocke(tabla, x, y+1, m, n);
	}

	k5 = ostali_topovi(tabla, x, y, m, n);

	if(k1 && k2 && k3 && k4 && k5) {
		return true;
	}else{
		return false;
	}
}

int main() {

	std::string line;
	getline(std::cin, line);

	int n = std::stoi(line.substr(0, line.find(" ")));
	int m = std::stoi(line.substr(line.find(" ")+1));

	std::vector<int> tabla;

	for(unsigned int y = 0; y < n; y++) {
		std::string red;
		getline(std::cin, red);

		for(unsigned int x = 0; x < m; x++) {
			if(red[x] == '0') {
				tabla.push_back(0);
			}else if(red[x] == '1') {
				tabla.push_back(1);
			}else if(red[x] == '2') {
				tabla.push_back(2);
			}else if(red[x] == '3') {
				tabla.push_back(3);
			}else if(red[x] == '4') {
				tabla.push_back(4);
			}else if(red[x] == '#') {
				tabla.push_back(5);
			}else if(red[x] == '.') {
				tabla.push_back(6);
			}
		}

	}

	for(int y = 0; y < n; y++) {
		for(int x = 0; x < m; x++) {
			if(tabla[y * m + x] < 5) {
				int broj = tabla[y * m + x];
				bool k1 = false;
				bool k2 = false;
				bool k3 = false;
				bool k4 = false;
				if(x > 0 && tabla[y * m + x-1] == 6) {
					k1 = proveri_top(tabla, x-1, y, m, n);
				}

				if(x < m-1 && tabla[y * m + x+1] == 6) {
					k2 = proveri_top(tabla, x+1, y, m, n);
				}

				if(y > 0 && tabla[(y-1) * m + x] == 6) {
					k3 = proveri_top(tabla, x, y-1, m, n);
				}

				if(y < n-1 && tabla[(y+1) * m + x] == 6) {
					k4 = proveri_top(tabla, x, y+1, m, n);
				}

				if(broj > 0) {
					if(k1) {
						tabla[y * m + x-1] = 7;
						broj--;
					}else{
						if(tabla[y * m + x-1] == 6) {
							tabla[y * m + x-1] = 8;
						}
					}
				}

				if(broj > 0) {
					if(k2) {
						tabla[y * m + x+1] = 7;
						broj--;
					}else{
						if(tabla[y * m + x+1] == 6) {
							tabla[y * m + x+1] = 8;
						}
					}
				}

				if(broj > 0) {
					if(k3) {
						tabla[(y-1) * m + x] = 7;
						broj--;
					}else{
						if(tabla[(y-1) * m + x] == 6) {
							tabla[(y-1) * m + x] = 8;
						}
					}
				}

				if(broj > 0) {
					if(k4) {
						tabla[(y+1) * m + x] = 7;
						broj--;
					}else{
						if(tabla[(y+1) * m + x] == 6) {
							tabla[(y+1) * m + x] = 8;
						}
					}
				}

				if(broj == 0) {
					if(tabla[y * m + x-1] == 6) {
						tabla[y * m + x-1] = 8;
					}
					if(tabla[y * m + x+1] == 6) {
						tabla[y * m + x+1] = 8;
					}
					if(tabla[(y-1) * m + x] == 6) {
						tabla[(y-1) * m + x] = 8;
					}
					if(tabla[(y+1) * m + x] == 6) {
						tabla[(y+1) * m + x] = 8;
					}
				}
			}
		}
	}

	struct pos {
		int x, y;
	};

	bool unsolvable = false;

	int prev = 0;
	int current = 0;

	while(true) {

		prev = current;

		std::vector<pos> leftover;

		bool more = false;
		for(int y = 0; y < n; y++) {
			for(int x = 0; x < m; x++) {
				if(tabla[y * m + x] == 6 || tabla[y * m + x] == 8) {
					bool k = ostali_topovi(tabla, x, y, m, n);

					if(!k) {
						tabla[y * m + x] = 8;
					}else{
						tabla[y * m + x] = 9;
						leftover.push_back({x, y});
						more = true;
					}
				}
			}
		}

		if(!more) {break;}

		current = leftover.size();

		if(prev == current) {unsolvable = true; break;}

		int bestX = -1;
		int bestY = -1;
		int best = 0;
		int bestid = -1;

		for(int i = 0; i < leftover.size(); i++) {
			int tmp_best = 0;
			for(int j = 0; j < leftover.size(); j++) {
				if(i != j) {
					if(leftover[j].y == leftover[i].y) {tmp_best++;}
					if(leftover[j].x == leftover[i].x) {tmp_best++;}
				}
			}

			if(tmp_best > best) {
				bestid = i;
				best = tmp_best;
				bestX = leftover[i].x;
				bestY = leftover[i].y;
			}
		}

		tabla[bestY * m + bestX] = 7;

		for(int i = 0; i < leftover.size(); i++) {
			if(i != bestid) {
				tabla[leftover[i].y * m + leftover[i].x] = 8;
			}
		}
	}

	if(unsolvable){
		std::cout << -1 << '\n';
	}else{
		napisi_tablu(tabla, m, n);
	}

	return 0;
}