#include <bits/stdc++.h>
#define debug(x) cout << #x << " is " << x << '\n';
#define stigao() cout << "Stigao" << '\n';
#define file() freopen("output.txt", "w", stdout);

#define x first
#define y second

using namespace std;

typedef long long ll;

/*
isEmpty = true
3 5
. . . . .
. . . . .
. . . . .

3 3
. # .
# # #
. # .

1 3
. 2 .

5 6
.#01.1
2.....
0.....
......
#...2.

1 5
1.2.1

3 3
1.2
...
...

5 5
0..#.
..4..
...#.
1.2..
.....

7 7
0......
....#.3
.1.#.#.
....#..
..##..#
..#....
.0.....

10 10
0.........
....#.3...
.1.###.2..
....#.....
..##..#...
..#.......
.0.......#
..0....4..
.0.0....2.
....0.....
*/

vector< pair<int, int> > p, d;
char mat[15][15];
bool isCoveredPoint[15][15];
int n, m, cntPoint;

bool isValidNumber(){
    int cnt = 0, i, j;
    for(auto k : d){
        cnt = 0;
        i = k.x;
        j = k.y;
        if(i > 0 && mat[i - 1][j] == 'C') cnt++;
        if(i < n - 1 && mat[i + 1][j] == 'C') cnt++;
        if(j > 0 && mat[i][j - 1] == 'C') cnt++;
        if(j < m - 1 && mat[i][j + 1] == 'C') cnt++;

        if(cnt != (mat[i][j] - '0'))
            return false;
    }

    return true;
}


bool isValidPlaced(){
    memset(isCoveredPoint, 0, sizeof(isCoveredPoint));
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            isCoveredPoint[i][j] = mat[i][j] != '.';
        }
    }

    for(auto c : p){
        if(mat[c.x][c.y] == 'C'){
            for(int k = c.x + 1; k < n; k++){
                if(mat[k][c.y] == '.')
                    isCoveredPoint[k][c.y] = true;
                else if(mat[k][c.y] == 'C')
                    return false;
                else
                    break;
            }
            for(int k = c.x - 1; k >= 0; k--){
                if(mat[k][c.y] == '.')
                    isCoveredPoint[k][c.y] = true;
                else if(mat[k][c.y] == 'C')
                    return false;
                else
                    break;

            }
            for(int k = c.y + 1; k < m; k++){
                if(mat[c.x][k] == '.')
                    isCoveredPoint[c.x][k] = true;
                else if(mat[c.x][k] == 'C')
                    return false;
                else
                    break;

            }
            for(int k = c.y - 1; k >= 0; k--){
                if(mat[c.x][k] == '.')
                    isCoveredPoint[c.x][k] = true;
                else if(mat[c.x][k] == 'C')
                    return false;
                else
                    break;
            }
        }
    }

    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            if(!isCoveredPoint[i][j])
                return false;
        }
    }
    return true;
}

bool canPlace(int iter){
    auto c = p[iter];
    for(int k = c.x + 1; k < n; k++){
        if(mat[k][c.y] == 'C')
            return false;
        else
            break;
    }
    for(int k = c.x - 1; k >= 0; k--){
        if(mat[k][c.y] == 'C')
            return false;
        else
            break;

    }
    for(int k = c.y + 1; k < m; k++){
        if(mat[c.x][k] == 'C')
            return false;
        else
            break;

    }
    for(int k = c.y - 1; k >= 0; k--){
        if(mat[c.x][k] == 'C')
            return false;
        else
            break;
    }

    return true;
}

bool solve(int iter){
    if(iter == cntPoint){
        return isValidNumber() && isValidPlaced();
    }
    if(solve(iter + 1))
        return true;
    if(canPlace(iter)){
        mat[p[iter].x][p[iter].y] = 'C';
        if(solve(iter + 1))
            return true;
        mat[p[iter].x][p[iter].y] = '.';
    }
    return false;
}

int main() {
    ios::sync_with_stdio(0), cin.tie(0), cout.tie(0);
    cin >> n >> m;
    bool isEmpty = true, solved = false;
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cin >> mat[i][j];
            if(mat[i][j] == '.'){
                p.push_back({i, j});
            } else {
                isEmpty = false;
                if(mat[i][j] >= '0' && mat[i][j] <= '4')
                    d.push_back({i, j});
            }
        }
    }
    if(isEmpty){
        int larger = max(n, m);
        for(int i = 0; i < larger; i++)
            mat[i][i] = 'C';
        solved = true;
    } else {
        cntPoint = p.size();
        solved = solve(0);
    }
    if(solved){
        for(int i = 0; i < n; i++){
            for(int j = 0; j < m; j++){
                cout << mat[i][j];
            }
            cout << '\n';
        }
    } else {
        cout << -1;
    }
    return 0;
}