#include <bits/stdc++.h>

using namespace std;

#define int ll
typedef long long ll;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<bool> vb;
typedef vector<char> vc;
typedef vector<string> vs;
typedef vector<pi> vp;
typedef vector<pl> vpl;

//Preuzeto sa:
//https://github.com/ivan100sic/competelib/blob/master/User/segtreelazy.sublime-snippet

template<int MAXN>
struct segtree_lazy {
	struct updater {
		/* DATA MEMBERS */
		int x;
		updater(int x = 0) : x(x) {}
		updater& operator+= (const updater& other) {
			/* ADDITION */
			x += other.x;
			return *this;
		}
		operator bool () const {
			/* BOOL CAST */
			return x != 0;
		}
	};
	
	struct node_t {
		/* DATA MEMBERS */
		int x;
		/* CONSTRUCTOR */
		node_t(int x = 0) : x(x) {}
		node_t& operator+= (const node_t& other) {
			/* ADDITION */
			x += other.x;
			return *this;
		}
		node_t& operator+= (const updater& other) {
			/* UPDATE ADDITION */
			x += other.x;
			return *this;
		}
		node_t operator+ (const node_t& other) const {
			node_t tmp = *this;
			tmp += other;
			return tmp;
		}
	};
	node_t a[2*MAXN];
	updater b[2*MAXN];
	void init() {
		for (int i=1; i<=MAXN; i++) {
			/* KOPIRAJ NEKI EKSTERNI NIZ OVDE */
			a[i + MAXN - 1] = node_t();
		}
		for (int i=MAXN-1; i>0; i--) {
			a[i] = a[2*i] + a[2*i+1];
		}
	}
	void push(int i) {
		if (b[i]) {
			a[i] += b[i];
			if (i < MAXN) {
				b[2*i] += b[i];
				b[2*i+1] += b[i];
			}
			b[i] = updater();
		}
	}
	node_t get(int l, int r, int node=1, int nl=1, int nr=MAXN) {
		push(node);
		if (r < nl || nr < l) {
			return node_t();
		}
		if (l <= nl && nr <= r) {
			return a[node];
		}
		int nm = (nl + nr) >> 1;
		return get(l, r, 2*node, nl, nm) + get(l, r, 2*node+1, nm+1, nr);
	}
	void update(int l, int r, updater val, int node=1, int nl=1, int nr=MAXN) {
		push(node);
		if (r < nl || nr < l) {
			return;
		}
		if (l <= nl && nr <= r) {
			b[node] += val;
			push(node);
			return;
		}
		int nm = (nl + nr) >> 1;
		update(l, r, val, 2*node, nl, nm);
		update(l, r, val, 2*node+1, nm+1, nr);
		a[node] = a[2*node] + a[2*node+1];
	}
};
segtree_lazy<131072> hrast, breza, f, s;

//hrast - 1
//breza - 0
//bastovanstvo je posten posao #prayfortrees

pi calc(int n, int m){
	int sol = 0, res = 0;
	for (int i = 1; i <= m; ++i){
		int x = hrast.get(i, i).x;
		sol += x * (n - x + 1);

		x = breza.get(i, i).x;
		res += x * (n - x + 1);
	}

	return {sol, res};
}

signed main()
{
	ios_base::sync_with_stdio(false); 
	cin.tie(nullptr); 
	cout.tie(nullptr); 
	cerr.tie(nullptr);	

	int n, m;
	cin >> n >> m;

	vi a(n);
	for (auto& i : a)
		cin >> i;

	vi p = {0}, q = {1};

	hrast.update(1, a[0], 1);
	breza.update(a[0] + 1, m, 1);

	int sol = INT32_MAX;
	for (int br = 1; br < n; ++br){
		hrast.update(1, a[br], 1);
		breza.update(1, a[br], 1);

		pi t = calc(br, m);
		if (t.first < t.second){
			f = hrast;
		} else {
			f = breza;
		}


		hrast.update(1, a[br], -1);
		breza.update(1, a[br], -1);

		hrast.update(a[br] + 1, m, 1);
		breza.update(a[br] + 1, m, 1);

		t = calc(br, m);
		if (t.first < t.second){
			s = hrast;
		} else {
			s = breza;
		}

		hrast = f;
		breza = s;
	}	

	pi t = calc(n - 1, m);
	cout << min(t.first, t.second) << '\n';
}