#include <bits/stdc++.h>
using namespace std;
#define ll long long
#define pb push_back
#define mp make_pair
#define ldb long double
#define mt make_tuple
const int N=12;
int n,m;
char base[N][N],sol[N][N],bsol[N][N];
bool has_sol,has_bsol;
void input()
{
	scanf("%i %i",&n,&m);
	for(int i=1;i<=n;i++)
		scanf("%s",base[i]+1);
}
void output()
{
	if(!has_sol) printf("-1\n");
	else for(int i=1;i<=n;i++) printf("%s\n",sol[i]+1);
}
bool CheckSolution(char s[N][N])
{
	//printf("Check:\n");
	//for(int i=1;i<=n;i++)
	//		printf("%s\n",s[i]+1);
	for(int i=1;i<=n;i++)
	{
		for(int j=1;j<=m;j++)
		{
			if(base[i][j]!='.' && base[i][j]!=s[i][j]) return 0;
			int br=0,k;
			for(k=j-1;s[i][k]=='.';k--);if(s[i][k]=='C') br++;
			for(k=j+1;s[i][k]=='.';k++);if(s[i][k]=='C') br++;
			for(k=i-1;s[k][j]=='.';k--);if(s[k][j]=='C') br++;
			for(k=i+1;s[k][j]=='.';k++);if(s[k][j]=='C') br++;
			if(s[i][j]=='C')
			{
				if(br) return 0;
			}
			else if(s[i][j]=='.')
			{
				if(!br) return 0;
			}
			else if(s[i][j]!='#')
			{
				int cnt=s[i][j]-'0';
				if(s[i][j-1]=='C') cnt--;
				if(s[i][j+1]=='C') cnt--;
				if(s[i-1][j]=='C') cnt--;
				if(s[i+1][j]=='C') cnt--;
				if(cnt!=0) return 0;
			}
		}
	}
	return 1;
}
int U[N][N],D[N][N],L[N][N],R[N][N];
int was[N][N],can[N],sz[N][N];
bool CheckCell(int x, int y)
{
	if(base[x][y]!='.' || !can[y]) return 0;
	if(sz[x-1][y]==0 || sz[x+1][y]==0 || sz[x][y-1]==0 || sz[x][y+1]==0) return 0;
	return 1;
}
void AddCell(int x, int y, int f, char c)
{
	sol[x][y]=c;
	for(int j=L[x][y]+1;j<R[x][y];j++) sz[x][j]+=f;
	for(int i=U[x][y]+1;i<D[x][y];i++) sz[i][y]+=f;
	if(sz[x-1][y]>=0) sz[x-1][y]+=f;
	if(sz[x+1][y]>=0) sz[x+1][y]+=f;
	if(sz[x][y-1]>=0) sz[x][y-1]+=f;
	if(sz[x][y+1]>=0) sz[x][y+1]+=f;
}
void Try(int x, int y, bool need)
{
	if(has_sol) return;
	if(y>m) x++,y=1;
	if(x>n)
	{
		if(CheckSolution(sol)) has_sol=1;
		return;
	}
	if(y==1) need=base[x][y]=='.';
	if(sz[x-1][y]>=0)
	{
		if(sz[x-1][y]>1) return;
	}
	if(base[x][y]=='.')
	{
		if(CheckCell(x,y) && need)
		{
			//printf("(%i %i)\n",x,y);
			AddCell(x,y,-1,'C');
			can[y]=0;
			//printf("Try:\n");
			//for(int i=1;i<=n;i++)
			//	printf("%s\n",sol[i]+1);
			Try(x,y+1,0);
			if(has_sol) return;
			can[y]=1;
			AddCell(x,y,1,'.');
		}
		if(sz[x-1][y]!=1) Try(x,y+1,need);
	}
	else
	{
		for(int k=U[x][y]+1;k<x;k++) if(sz[k][y]==-1) return;
		int pre=can[y];
		can[y]=1;
		Try(x,y+1,1);
		can[y]=pre;
	}
}
void Solve()
{
	for(int i=0;i<=n+1;i++) for(int j=0;j<=m+1;j++) sz[i][j]=-1,sol[i][j]=base[i][j];
	has_sol=0;
	for(int i=1;i<=n;i++)
	{
		for(int j=1;j<=m;j++)
		{
			int k;
			for(k=j-1;base[i][k]=='.';k--);L[i][j]=k;
			for(k=j+1;base[i][k]=='.';k++);R[i][j]=k;
			for(k=i-1;base[k][j]=='.';k--);U[i][j]=k;
			for(k=i+1;base[k][j]=='.';k++);D[i][j]=k;
			was[i][j]=0;
			if(base[i][j]>='0' && base[i][j]<='4') sz[i][j]=base[i][j]-'0';
			else sz[i][j]=-1;
		}
	}
	for(int i=1;i<=m;i++) can[i]=1;
	Try(1,1,base[1][1]=='.');
}
void Run()
{
	input();
	Solve();
	output();
}
void BruteForce()
{
	vector<pair<int,int>> emp;
	for(int i=1;i<=n;i++)
		for(int j=1;j<=m;j++)
			if(base[i][j]=='.')
				emp.pb(mp(i,j));
	int sz=emp.size();
	has_bsol=0;
	for(int mask=0;mask<1<<sz;mask++)
	{
		for(int i=0;i<=n+1;i++) for(int j=0;j<=m+1;j++) bsol[i][j]=base[i][j];
		for(int i=0;i<sz;i++) if((mask>>i)&1) bsol[emp[i].first][emp[i].second]='C';
		if(CheckSolution(bsol)){ has_bsol=1;return;}
	}
}
void RunBrute()
{
	input();
	BruteForce();
	if(!has_bsol) printf("-1\n");
	else for(int i=1;i<=n;i++) printf("%s\n",bsol[i]+1);
}
void MakeTestCase()
{
	n=10;
	m=10;
	for(int i=0;i<=n+1;i++)
		for(int j=0;j<=m+1;j++)
			base[i][j]=0;
	for(int i=1;i<=n;i++)
	{
		for(int j=1;j<=m;j++)
		{
			if(rand()%100==1)
			{
				int p=rand()%6;
				if(p==5) base[i][j]='#';
				else base[i][j]='0'+p;
			}
			else base[i][j]='.';
		}
	}
}
bool Compare()
{
	if(!has_sol && !has_bsol) return 1;
	if(has_sol && !CheckSolution(sol)) return 0;
	if(has_bsol && !CheckSolution(bsol)) return 0;
	return 1;
}
void Print()
{
	printf("%i %i\n",n,m);
	for(int i=1;i<=n;i++) printf("%s\n",base[i]+1);
	printf("Solve:\n");
	if(!has_sol) printf("-1\n");
	else for(int i=1;i<=n;i++) printf("%s\n",sol[i]+1);
	printf("Brute:\n");
	if(!has_bsol) printf("-1\n");
	else for(int i=1;i<=n;i++) printf("%s\n",bsol[i]+1);
}
double GetTime(){ return (ldb)clock()/CLOCKS_PER_SEC;}
double s_time,e_time,d_time;
void Start(){ s_time=GetTime();}
void Stop(){ e_time=GetTime();d_time=e_time-s_time;}
void Test()
{
	cout<<fixed<<setprecision(4);
	int work=100000;
	double max_time=0;
	bool speed_only=1;
	for(int i=1;i<=work;i++)
	{
		MakeTestCase();
		if(!speed_only) BruteForce();
		Start();
		Solve();
		Stop();
		if(!speed_only && !Compare())
		{
			Print();
			return;
		}
		max_time=max(max_time,d_time);
		cout<<i<<":OK, max time so far="<<max_time<<"\n";
	}
	cout<<":D\n";
}
int main()
{
	int test=0;
	if(test==1) Test();
	else if(test==0) Run();
	else RunBrute();
	return 0;
}