#include <array>
#include <algorithm>
#include <iostream>
#include <cstddef>

std::array<unsigned long long, 19> digit_divisors {{
    1000000000000000000,
    100000000000000000,
    10000000000000000,
    1000000000000000,
    100000000000000,
    10000000000000,
    1000000000000,
    100000000000,
    10000000000,
    1000000000,
    100000000,
    10000000,
    1000000,
    100000,
    10000,
    1000,
    100,
    10,
    1,
}};

using Numbers = std::array<unsigned long long, 3>;

inline unsigned long long fix_number(unsigned long long number)
{
    for (std::size_t i = 0; i < digit_divisors.size(); ++i)
    {
        if (number >= digit_divisors[i])
            return number * digit_divisors[digit_divisors.size() - i - 1];
    }
    return number;
}

inline void sort_numbers(Numbers& numbers) noexcept
{
    std::sort(numbers.begin(), numbers.end(),
        [](unsigned long long a, unsigned long long b) noexcept
        {
            a = fix_number(a);
            b = fix_number(b);

            for (auto const divisor : digit_divisors)
            {
                unsigned long long const a_digit = a / divisor;
                unsigned long long const b_digit = b / divisor;
                a -= a_digit * divisor;
                b -= b_digit * divisor;
                if (a_digit > b_digit)
                    return true;
                if (a_digit < b_digit)
                    return false;
            }
            return false;
        }
    );
}

#ifndef FORGET_MAIN
int main(int, char**)
{
    std::ios::sync_with_stdio(false);

    Numbers numbers;
    std::cin >> numbers[0];
    std::cin >> numbers[1];
    std::cin >> numbers[2];

    sort_numbers(numbers);

    std::cout << numbers[0] << numbers[1] << numbers[2] << '\n';
}
#endif